/*
 * Decompiled with CFR 0.152.
 */
package cn.kw.lib.common;

import cn.kw.lib.common.Text;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Zip {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] gz(byte[] plain) throws Exception {
        byte[] byArray;
        ByteArrayInputStream input = null;
        ByteArrayOutputStream output = null;
        GZIPOutputStream gzOutput = null;
        try {
            input = new ByteArrayInputStream(plain);
            output = new ByteArrayOutputStream();
            gzOutput = new GZIPOutputStream(output);
            gzOutput.write(plain);
            gzOutput.close();
            byArray = output.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new Exception("compress(gzip) failed(IOException)", e);
                catch (NullPointerException e2) {
                    throw new Exception("compress(gzip) failed(NullPointerException)", e2);
                }
            }
            catch (Throwable throwable) {
                Zip.close(gzOutput);
                Zip.close(input);
                Zip.close(output);
                throw throwable;
            }
        }
        Zip.close(gzOutput);
        Zip.close(input);
        Zip.close(output);
        return byArray;
    }

    private static void close(Closeable closeable) {
        try {
            if (null != closeable) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static byte[] ungz(byte[] cipher) throws Exception {
        try {
            return Zip.ungz0(cipher);
        }
        catch (Exception e) {
            return Zip.doWhileUNGZFailed(e, cipher);
        }
    }

    private static byte[] doWhileUNGZFailed(Exception e, byte[] cipher) throws Exception {
        try {
            if (e instanceof IOException && Text.contains(e.getMessage(), "unknown format") && null != cipher && cipher.length > 0) {
                return cipher;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] ungz0(byte[] cipher) throws Exception {
        byte[] byArray;
        ByteArrayInputStream input = null;
        ByteArrayOutputStream output = null;
        GZIPInputStream gzInput = null;
        int length = 0;
        byte[] buffer = new byte[1024];
        try {
            output = new ByteArrayOutputStream();
            input = new ByteArrayInputStream(cipher);
            gzInput = new GZIPInputStream(input);
            while ((length = gzInput.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            Zip.close(gzInput);
            Zip.close(input);
            Zip.close(output);
            throw throwable;
        }
        Zip.close(gzInput);
        Zip.close(input);
        Zip.close(output);
        return byArray;
    }
}

