package com.ads.cal.picturetranslate.base;

import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ExperimentalGetImage;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.ads.cal.picturetranslate.LogUtils;
import com.ads.cal.picturetranslate.R;
import com.ads.cal.picturetranslate.activity.PictureTranslateStartActivity;
import com.ads.cal.picturetranslate.adapter.PictureTranslateListAdapter;
import com.ads.cal.picturetranslate.bean.PictureTranslateBean;
import com.ads.cal.picturetranslate.fragment.LoadingFragment;


import java.util.Locale;

@ExperimentalGetImage public class BaseActivity extends FragmentActivity {

    protected final static int init = 0;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (init == 0) {
            return;
        }




        if (this instanceof PictureTranslateStartActivity) {
            return;
        }
        getWindow().setStatusBarColor(getColor(R.color.color_0073FF)); // 设置颜色
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onRestart() {
        super.onRestart();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    protected void showLoadingFragment(LoadingFragment fragment) {
        FragmentManager fragmentManager = getSupportFragmentManager();
        if (!fragment.isAdded()) {
            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
            fragmentTransaction.add(android.R.id.content, fragment);
            fragmentTransaction.addToBackStack("loadingFragment");
            fragmentTransaction.commit();
        }
    }

    protected void hideLoadingFragment() {
        FragmentManager fragmentManager = getSupportFragmentManager();
        if (fragmentManager.getBackStackEntryCount() > 0) {
            fragmentManager.popBackStack();
        }
    }

    protected void showFragment(Fragment fragment, int containerViewId) {
        FragmentManager fragmentManager = getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        if (!fragment.isAdded()) {
            fragmentTransaction.add(containerViewId, fragment);
            if (containerViewId == android.R.id.content) {
                fragmentTransaction.addToBackStack("fragment");
            }
            fragmentTransaction.commit();
        } else {
            fragmentTransaction.show(fragment);
        }
    }

    public void popBackStackFragment() {
        FragmentManager fragmentManager = getSupportFragmentManager();
        if (fragmentManager.getBackStackEntryCount() > 0) {
            fragmentManager.popBackStack();
        }
    }

    protected void hineFragment(Fragment fragment) {
        FragmentManager fragmentManager = getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.hide(fragment);
    }


//    private void refreshAd() {
//        AdLoader.Builder builder = new AdLoader.Builder(this, ADMOB_AD_UNIT_ID);
//        // OnLoadedListener implementation.
//        builder.forNativeAd(nativeAd -> {
//            // If this callback occurs after the activity is destroyed, you must call
//            // destroy and return or you may get a memory leak.
//            boolean isDestroyed = isDestroyed();
//            if (isDestroyed || isFinishing() || isChangingConfigurations()) {
//                nativeAd.destroy();
//                return;
//            }
//            // You must call destroy on old ads when you are done with them,
//            // otherwise you will have a memory leak.
//            if (BaseActivity.this.nativeAd != null) {
//                BaseActivity.this.nativeAd.destroy();
//            }
//            BaseActivity.this.nativeAd = nativeAd;
////            FrameLayout frameLayout = findViewById(R.id.ad_layout);
////            NativeAdView adView = (NativeAdView) getLayoutInflater().inflate(R.layout.ad_unified, frameLayout, false);
////            populateNativeAdView(nativeAd, adView);
////            frameLayout.removeAllViews();
////            frameLayout.addView(adView);
////            NativeTemplateStyle styles = null;
////            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
////                styles = new NativeTemplateStyle.Builder().withMainBackgroundColor(new ColorDrawable(getColor(R.color.white))).build();
////            } else {
////                styles = new NativeTemplateStyle.Builder().withMainBackgroundColor(new ColorDrawable(getResources().getColor(R.color.white))).build();
////            }
////            TemplateView template = findViewById(R.id.ad_layout);
////            template.setStyles(styles);
////            template.setNativeAd(nativeAd);
//        });
//
//        VideoOptions videoOptions = new VideoOptions.Builder().setStartMuted(false).build();
//
//        NativeAdOptions adOptions = new NativeAdOptions.Builder().setVideoOptions(videoOptions).build();
//
//        builder.withNativeAdOptions(adOptions);
//
//        AdLoader adLoader = builder.withAdListener(new AdListener() {
//            @Override
//            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
//                String error = String.format(Locale.getDefault(), "domain: %s, code: %d, message: %s", loadAdError.getDomain(), loadAdError.getCode(), loadAdError.getMessage());
//                LogUtils.d("home native onAdLoad  Failed     " +  error);
////                FireBaseAnalyticsUtils.init().send(AD_HOME_NATIVE_LOAD_FAILED);
//            }
//
//            @Override
//            public void onAdLoaded() {
//                super.onAdLoaded();
//                LogUtils.d("home native onAdLoaded");
////                FireBaseAnalyticsUtils.init().send(AD_HOME_NATIVE_LOAD_SUCCESS);
//            }
//
//            @Override
//            public void onAdClicked() {
//                super.onAdClicked();
//                LogUtils.d("home native onAdClicked");
////                FireBaseAnalyticsUtils.init().send(AD_HOME_NATIVE_CLK);
//            }
//
//            @Override
//            public void onAdClosed() {
//                super.onAdClosed();
//                LogUtils.d("home native onAdClosed");
////                FireBaseAnalyticsUtils.init().send(AD_HOME_NATIVE_CLOSE);
//            }
//
//            @Override
//            public void onAdImpression() {
//                super.onAdImpression();
//                LogUtils.d("home native onAdImpression");
////                FireBaseAnalyticsUtils.init().send(AD_HOME_NATIVE_EXP);
//            }
//
//            @Override
//            public void onAdOpened() {
//                super.onAdOpened();
//            }
//
//        }).build();
//
//        adLoader.loadAd(new AdRequest.Builder().build());
////        FireBaseAnalyticsUtils.init().send(AD_HOME_NATIVE_START_LOAD);
//        LogUtils.d("home native onAdLoad  start     " );
//    }

}
