package com.gem.media;

import android.content.Context;
import android.util.Log;

import com.gem.media.splash.base.utils.ALog;
import com.or.ange.dot.UsageStats;

import java.util.HashMap;
import java.util.Map;

public class StatsStaticHelper {

    private static final String TAG = "StatsStaticHelper";

    public static void onEvent(String eventId) {
        onEvent(eventId, new HashMap<>());
    }

    public static void onEvent(String eventId, String label) {
        onEvent(eventId, label, new HashMap<>());
    }

    public static void onEvent(String eventId, String label, Map<String, String> params) {
        try {
            params.put("uuid", InitA.getInstance().getUuid());
            UsageStats.onEvent(eventId, label, params);
        } catch (Exception e) {
            ALog.e(TAG,"onEvent 2 e :" + Log.getStackTraceString(e));
        }
    }

    public static void onEvent(String eventId, Map<String, String> params) {
        try {

            params.put("uuid", InitA.getInstance().getUuid());
            UsageStats.onEvent(eventId, "", params);
        } catch (Exception e) {
            ALog.e(TAG,"onEvent 3 e :" + Log.getStackTraceString(e));
        }
    }
}
