package com.gem.media;

import com.gem.media.splash.base.utils.ALog;

import java.util.Timer;
import java.util.TimerTask;

public class KpLiveHelper {


    private static final class KpLiveHelperHolder {
        private static final KpLiveHelper kpLiveUtil = new KpLiveHelper();
    }

    public static KpLiveHelper getInstance() {
        return KpLiveHelperHolder.kpLiveUtil;
    }

    private Timer timer;
    private static final long TIME = 60 * 1000;
    private long minute = 0L;


    public void init() {
        if (null == timer) {
            timer = new Timer("MediaSchedule", true);
            timer.schedule(new TimerTask() {
                @Override
                public void run() {
                    if (minute == Long.MAX_VALUE) {
                        minute = 0L;
                    }
                    minute++;
                    for (Time m: Time.values()) {
                        if (minute % m.getMinute() == 0L) {
                            //每分钟触发一次
                            ALog.e("KpLiveHelper", "minute : "+ minute + ",it.minute :" + m.getMinute());
                            if (minute > 1 && m.getMinute() == 1) {
                                try {
                                    RestartAndOnlineTimeStaticsHelper.checkOnLineTime(m.getMinute());
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }

                            }
                        }
                    }
                }
            }, 0, TIME);
        }
    }
}
