package com.gem.media.util;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;

public class UACreator {
    private static final String USERAGENT_ANDROID = "Mozilla/5.0 (Linux; Android %s; %s Build/%s; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/126.0.6478.186 Safari/537.36";
    private static final String UA_RV = " RV/";

    public static String createUA() {
        return getUseragent_android();
    }

    private static String getUseragent_android() {
        String release = getOSVersion();
        String buildID = android.os.Build.ID;
        return String.format(USERAGENT_ANDROID, release, Build.DEVICE, buildID);
    }

    private static String getUASuffix() {
        StringBuilder uaSuffix = new StringBuilder();
        uaSuffix.append("");

        return uaSuffix.toString();
    }

    private static String getUASuffix_RV() {
        return UA_RV + getOSVersion();
    }


    public static String getOSVersion() {
        try {
            String release = Build.VERSION.RELEASE; // android系统版本号
            if (TextUtils.isEmpty(release)) {
                release = "";
            }
            return release;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

}
