package com.ads.cal.picturetranslate.fragment;

import android.app.Activity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ExperimentalGetImage;
import androidx.fragment.app.Fragment;

import com.ads.cal.picturetranslate.PictureApplication;
import com.ads.cal.picturetranslate.R;
import com.ads.cal.picturetranslate.ThreadUtils;
import com.ads.cal.picturetranslate.activity.PictureTranslateListMainActivity;
import com.ads.cal.picturetranslate.base.BaseActivity;

@ExperimentalGetImage public class DeleteFragment extends Fragment {


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return initView(inflater);
    }

    private View initView(LayoutInflater inflater) {
        View view = inflater.inflate(R.layout.fragment_delete, null, false);
        TextView cancel = view.findViewById(R.id.cancel);
        TextView clear = view.findViewById(R.id.clear);
        cancel.setOnClickListener(v -> backFragment());
        clear.setOnClickListener(v -> {
            ThreadUtils.startRunnable(() -> {
                PictureApplication.getDataBaseManager().deleteData();
                Activity activity = getActivity();
                if (activity != null) {
                    activity.runOnUiThread(() -> {
                        if (activity instanceof PictureTranslateListMainActivity) {
                            ((PictureTranslateListMainActivity)activity).requestData();
                        }
                        backFragment();
                    });
                }
            });
        });
        return view;
    }

    private void backFragment() {
        Activity activity = getActivity();
        if (activity instanceof BaseActivity) {
            ((BaseActivity)activity).popBackStackFragment();
        }
    }
}
