package com.ads.cal.picturetranslate.fragment;

import android.app.Activity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ExperimentalGetImage;
import androidx.fragment.app.Fragment;

import com.ads.cal.picturetranslate.R;
import com.ads.cal.picturetranslate.activity.PictureTranslateShowPhotoActivity;
import com.ads.cal.picturetranslate.base.BaseActivity;

@ExperimentalGetImage public class AgainFragment extends Fragment {

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return initView(inflater);
    }

    private View initView(LayoutInflater inflater) {
        View view = inflater.inflate(R.layout.fragment_again, null, false);
        view.findViewById(R.id.got_it).setOnClickListener(v -> {
            Activity activity = getActivity();
            if (activity instanceof PictureTranslateShowPhotoActivity) {
                ((PictureTranslateShowPhotoActivity)activity).extractFunction();
            }
            backFragment();
        });


        return view;
    }



    private void backFragment() {
        Activity activity = getActivity();
        if (activity instanceof BaseActivity) {
            ((BaseActivity)activity).popBackStackFragment();
        }
    }
}
