package com.ads.cal.picturetranslate.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;

import com.ads.cal.picturetranslate.LogUtils;
import com.ads.cal.picturetranslate.bean.PictureTranslateBean;

import java.util.ArrayList;
import java.util.List;

public class DataBaseManager {

    private final PictureTranslateDataBaseHelper dbHelper;
    private SQLiteDatabase database;

    public DataBaseManager(Context context) {
        dbHelper = new PictureTranslateDataBaseHelper(context);
    }

    // 打开数据库连接
    public void open() throws SQLException {
        database = dbHelper.getWritableDatabase();
    }

    // 关闭数据库连接
    public void close() {
        dbHelper.close();
    }

    // 插入数据
    public long insertData(String imageUrl, String title, long createTime) {
        ContentValues values = new ContentValues();
        values.put(PictureTranslateDataBaseHelper.COLUMN_IMAGE_URL, imageUrl);
        values.put(PictureTranslateDataBaseHelper.COLUMN_TITLE, title);
        values.put(PictureTranslateDataBaseHelper.COLUMN_TIME, createTime);
        return database.insert(PictureTranslateDataBaseHelper.TABLE_NAME, null, values);
    }

    // 查询数据
    public List<PictureTranslateBean> queryData() {
        String[] columns = {PictureTranslateDataBaseHelper.COLUMN_IMAGE_URL, PictureTranslateDataBaseHelper.COLUMN_TITLE, PictureTranslateDataBaseHelper.COLUMN_TIME};
        Cursor cursor = database.query(PictureTranslateDataBaseHelper.TABLE_NAME, columns, null, null, null, null, null);

        List<PictureTranslateBean> dataList = new ArrayList<>();

        if (cursor != null) {
            try {
                while (cursor.moveToNext()) {
                    String imageUrl = cursor.getString(cursor.getColumnIndex(PictureTranslateDataBaseHelper.COLUMN_IMAGE_URL));
                    String title = cursor.getString(cursor.getColumnIndex(PictureTranslateDataBaseHelper.COLUMN_TITLE));
                    long time = cursor.getLong(cursor.getColumnIndex(PictureTranslateDataBaseHelper.COLUMN_TIME));

                    // 创建 PictureTranslateData 对象并添加到列表中
                    PictureTranslateBean data = new PictureTranslateBean();
                    data.setTime(time);
                    data.setTitle(title);
                    data.setImageUrl(imageUrl);
                    dataList.add(data);
                }
            } catch (Exception e) {
                LogUtils.e(e.getMessage());
            } finally {
                cursor.close(); // 记得关闭 Cursor
            }
        }

        return dataList;
    }

    // 更新数据
    public int updateData(String imageUrl, String title, long createTime) {
        ContentValues values = new ContentValues();
        values.put(PictureTranslateDataBaseHelper.COLUMN_IMAGE_URL, imageUrl);
        values.put(PictureTranslateDataBaseHelper.COLUMN_TITLE, title);
        values.put(PictureTranslateDataBaseHelper.COLUMN_TIME, createTime);
        return database.update(PictureTranslateDataBaseHelper.TABLE_NAME, values, "createTime=" + createTime, null);
    }

    public boolean deleteData(long createTime) {
        int rowsAffected = database.delete(
                PictureTranslateDataBaseHelper.TABLE_NAME,
                PictureTranslateDataBaseHelper.COLUMN_TIME + "=" + createTime,
                null);

        return rowsAffected > 0;
    }

    public boolean deleteData() {
        int rowsAffected = database.delete(
                PictureTranslateDataBaseHelper.TABLE_NAME,
                null,
                null);

        return rowsAffected > 0;
    }

}
