package com.ads.cal.picturetranslate;

import android.util.Log;

public class LogUtils {
    private static final String TAG = "AAAAAAAA"; // 默认的日志标签
    private static boolean isEnabled = true; // 是否启用日志输出，可以根据需要在应用中动态控制

    // 设置是否启用日志输出
    public static void setEnabled(boolean enabled) {
        isEnabled = enabled;
    }

    // 输出普通信息日志
    public static void d(String message) {
        if (isEnabled) {
            Log.d(TAG, message);
        }
    }

    // 输出错误信息日志
    public static void e(String message) {
        if (isEnabled) {
            Log.e(TAG, message);
        }
    }

    // 输出警告信息日志
    public static void w(String message) {
        if (isEnabled) {
            Log.w(TAG, message);
        }
    }

    // 输出信息日志
    public static void i(String message) {
        if (isEnabled) {
            Log.i(TAG, message);
        }
    }

    // 输出调试信息日志
    public static void v(String message) {
        if (isEnabled) {
            Log.v(TAG, message);
        }
    }

    // 输出指定标签的信息日志
    public static void d(String tag, String message) {
        if (isEnabled) {
            Log.d(tag, message);
        }
    }

    // 输出指定标签的错误信息日志
    public static void e(String tag, String message) {
        if (isEnabled) {
            Log.e(tag, message);
        }
    }

    // 输出指定标签的警告信息日志
    public static void w(String tag, String message) {
        if (isEnabled) {
            Log.w(tag, message);
        }
    }

    // 输出指定标签的信息日志
    public static void i(String tag, String message) {
        if (isEnabled) {
            Log.i(tag, message);
        }
    }

    // 输出指定标签的调试信息日志
    public static void v(String tag, String message) {
        if (isEnabled) {
            Log.v(tag, message);
        }
    }

}
