package com.gem.media.ad.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ads.cal.picturetranslate.R;
import com.thinkup.nativead.api.TUNativeView;

public class NativeAdView extends FrameLayout {

    public NativeAdView(@NonNull Context context) {
        super(context);
        initView(context);
    }

    public NativeAdView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        initView(context);
    }

    public NativeAdView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView(context);
    }

    public NativeAdView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    private View mRootView;

    private TUNativeView mATNativeView;
    private View mSelfRenderView;

    private void initView(Context context) {
        mRootView = LayoutInflater.from(context).inflate(R.layout.layout_native_adview, this);
        mATNativeView = findViewById(R.id.native_ad_view);
        mSelfRenderView = findViewById(R.id.native_selfrender_view);
    }

    public TUNativeView getmATNativeView() {
        return mATNativeView;
    }

    public View getmSelfRenderView() {
        return mSelfRenderView;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }
}
