package com.gem.media.ad.service;


import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ads.cal.picturetranslate.PictureApplication;
import com.android.gem.core.XGENAdData;
import com.gem.media.InitA;
import com.gem.media.NativeAdWindManager;
import com.gem.media.ad.AdData;
import com.gem.media.ad.AdManager;
import com.gem.media.ad.CpAdData;
import com.gem.media.ad.InterstitialAdManager;
import com.gem.media.ad.InterstitialHalfAdManager;
import com.gem.media.ad.NativeAdManager;
import com.gem.media.ad.OpenAdManager;
import com.gem.media.splash.base.utils.ALog;

public class MyDataService extends Service {

    private static final String TAG = "MyAdService";
    private static final String PARAM_DATA = "adData";
    public static final String PARAM_CPID = "cpId";
    public static final String PARAM_APPID_CHANNELID = "adAppId_channelId";
    public static final String PARAM_AD_TYPE = "adType";
    public static final String PARAM_ADID = "adId";
    public static final String PARAM_CHANNELID= "channelId";
    private static final String NEW_DEX_VERSION = "1";
    private static final int AD_DATA_TYPE = 2;
    public static final String T_ = "_";

    private static final int NEW_CONTENT_VERSION_CODE = 1;
    private static final int MSG_WHAT = 1234;
    private static final int MSG_WHAT4 = 1237;
    private static final Handler handler =  new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            if (msg.what == MSG_WHAT) {
                Bundle bundle = msg.getData();
                if (null != bundle) {
                    String cpId = bundle.getString("cpId");
                    String adAppId_channelId = bundle.getString("adAppId_channelId");
                    String adType = bundle.getString("adType");
                    String appKey = bundle.getString("appKey");
                    String adId = bundle.getString("adId");
                    setData(cpId, adAppId_channelId, appKey, adType, adId);
                }
            }
        }
    };


    @Override
    public void onCreate() {
        super.onCreate();
        ALog.d(TAG, "onCreate");
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        ALog.d(TAG, "onBind");
        return binder;
    }


    private static final AdServiceBinder binder = new AdServiceBinder();

    public static class AdServiceBinder extends XGENAdData.Stub {


        @Override
        public void setAdData(String cpId, String adAppId_channelId, String adType, String appKey, String adId) throws RemoteException {
            //"a6501757a165c4"
            ALog.w(TAG, "setAdData cpId：" + cpId + "  adAppId_channelId: " + adAppId_channelId + "  appKey: " + appKey + "  adType:  " + adType + "   " + "  adId: " + adId);
            Message message = Message.obtain();
            Bundle bundle = new Bundle();
            bundle.putString("cpId", cpId);
            bundle.putString("adAppId_channelId", adAppId_channelId);
            bundle.putString("adType", adType);
            bundle.putString("appKey", appKey);
            bundle.putString("adId", adId);
            message.setData(bundle);
            message.what = MSG_WHAT;
            handler.sendMessage(message);
        }

        @Override
        public void setMyMessenger(Messenger myMessenger) throws RemoteException {
            InitA.getInstance().setMessenger(myMessenger);
        }

        @Override
        public boolean isAdReady() throws RemoteException {
            return AdManager.getInstance().hasCache();
        }

        @Override
        public boolean adIsLoading() throws RemoteException {
            return AdManager.getInstance().adIsLoading();
        }

        @Override
        public int newContentVersionCode() throws RemoteException {
            return NEW_CONTENT_VERSION_CODE;
        }

        @Override
        public void setCanNextRequestAd(boolean can) throws RemoteException {
            AdManager.getInstance().setCanNextAdRequest(can);
        }

        @Override
        public void setUuid(String uuid) throws RemoteException  {
            ALog.w(TAG, "setUuid     " + uuid );
            InitA.getInstance().setUuid(uuid);
        }

        @Override
        public void setAlertWindowOpen(boolean open) throws RemoteException  {
            ALog.w(TAG, "setAlertWindowOpen     " + open );
            InitA.getInstance().setAlertWindowOpen(open);
        }

        @Override
        public void initMediaApp(String channelId) throws RemoteException  {
            String value = null;
            if (channelId.contains("_")) {
                String[] s = channelId.split("_");
                if (s.length > 1) {
                    value = s[1];
                }
            } else {
                value = channelId;
            }
            ALog.w(TAG, "initMediaApp     " + value );
            InitA.getInstance().initMediaApp(value, PictureApplication.getApplication());
        }

        @Override
        public void closeActivity() throws RemoteException  {
            InitA.getInstance().closeActivity(2);
        }

        @Override
        public void showNAd() throws RemoteException {
            ALog.w(TAG, "showNAd     "  );
            NativeAdWindManager.getInstance().createNativeAdView(AdData.AD_TYPE_NATIVE);
        }

        @Override
        public void showInterstitialHalfAd() throws RemoteException {
            ALog.w(TAG, "showInterstitialHalfAd     "  );
            NativeAdWindManager.getInstance().createNativeAdView(AdData.AD_TYPE_HALF_INTERSTITIAL);
        }

        @Override
        public void closeNAd() throws RemoteException {
            ALog.w(TAG, "clsoeNAd     "  );
            NativeAdWindManager.getInstance().removeNativeAd();
        }

        @Override
        public void setNCanNextRequestAd(boolean can) throws RemoteException {
            ALog.w(TAG, "setNCanNextRequestAd     can = " + can );
            NativeAdManager.getInstance().setCanNNextRequestAd(can);

        }
        @Override
        public void transferData(int type, String data) {
            if (null == data || data.isEmpty()) {
                ALog.d(TAG, "parseData is null");
                return;
            }
            parseData(type, data);
        }
        private void parseData(int type, String data) {
            ALog.d(TAG, "parseData type = " +type + " data =" + data);
            switch (type) {
                case AD_DATA_TYPE:
                    if (!InitA.getInstance().isAppBackground()) {
                        return;
                    }
                    Message message = Message.obtain();
                    Bundle bundle = new Bundle();
                    bundle.putString(PARAM_DATA, data);
                    message.setData(bundle);
                    message.what = MSG_WHAT4;
                    handler.sendMessage(message);
                    break;
                default:
                    break;
            }
        }
    }

//    private static String cpId;
//    private static  String adAppId_channelId;
//    private static String appkey;
//    private static String adType;
//    private static String adId;

    private static void setData(String cpId, String adAppId_channelId, String appKey, String adType, String adId) {
        if (!TextUtils.isEmpty(cpId) && CpAdData.CP_TOPON.equals(cpId)) {
            String adAppId = CpAdData.initTopOnAdSdk(adAppId_channelId, appKey);
            //"b1f138leh1o4gp"
            if (AdData.AD_TYPE_OPEN.equals(adType)) {
                ALog.w(TAG, "AD_TYPE_OPEN     " + adAppId_channelId + "  " + adType + "   " + adId);
                OpenAdManager.getInstance().loadAd(adId);
            }
            //b6509805ed0208
            if (AdData.AD_TYPE_INTERSTITIAL.equals(adType)) {
                ALog.w(TAG, "AD_TYPE_INTERSTITIAL     " + adAppId_channelId + "  " + adType + "   " + adId);
                InterstitialAdManager.getInstance().loadAd(adId);
            }
            //b1f138leh1o9t5
            if (AdData.AD_TYPE_NATIVE.equals(adType)) {
                ALog.w(TAG, "AD_TYPE_NATIVE     " + adAppId_channelId + "  " + adType + "   " + adId);
                NativeAdManager.getInstance().loadAd(adId, 1);
            }
            if (AdData.AD_TYPE_HALF_INTERSTITIAL.equals(adType)) {
                ALog.w(TAG, "halfChapin     " + adAppId_channelId + "  " + adType + "   " + adId);
                InterstitialHalfAdManager.getInstance().loadAd(adId);
            }
            AdData adData = CpAdData.getInstance().getAdData(cpId);
            if (adData == null) {
                adData = new AdData();
            }
            adData.setAdType(adType);
            adData.setAppId(adAppId);
            adData.addData(adType, adId);
            CpAdData.getInstance().setCpData(cpId, adData);
        }
    }

    private static long lastClickTime = 0;
    private static final long clickInterval = 1000; // 设置点击间隔为1秒

    public static boolean isFastRequest() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastClickTime >= clickInterval) {
            lastClickTime = currentTime;
            return false;
        }
        lastClickTime = currentTime;
        return true;
    }
}


