package com.gem.media;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

import androidx.annotation.Nullable;

import com.ads.cal.picturetranslate.R;
import com.android.gem.core.ReportBean;
import com.gem.media.ad.AdData;
import com.gem.media.ad.InterstitialHalfAdManager;
import com.gem.media.ad.NativeAdManager;
import com.gem.media.splash.base.protocol.Constants;
import com.gem.media.splash.base.utils.ALog;
import com.thinkup.nativead.api.TUNativeView;


import java.util.HashMap;
import java.util.Map;

public class NActivity extends Activity {

    private static final String TAG = "CCNActivity";

    private boolean isFinished;
    private String adType;

    private int i = 0;


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (i == 0) {
            finish();
            return;
        }
        Window window = getWindow();
        window.addFlags(WindowManager.LayoutParams.FLAG_SECURE);
        setContentView(R.layout.n_layout);
        report("onCreate");
        start();
        ALog.d(TAG, "onCreate");

    }

    private void getData() {
        Intent intent = getIntent();
        if (null != intent) {
            adType = intent.getStringExtra("adType");
        }
        if (TextUtils.isEmpty(adType)) {
            adType = AdData.AD_TYPE_NATIVE;
        }
        ALog.d(TAG, "getData adType "+adType);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        report("onNewIntent");
        start();
        ALog.d(TAG, "onNewIntent");

    }

    private void start() {
        getData();
        if (adType.equals(AdData.AD_TYPE_HALF_INTERSTITIAL)) {
            if (InterstitialHalfAdManager.getInstance().isInterstitialHalfAdReady()) {
                TUNativeView mATNativeView = findViewById(R.id.native_ad_view);
                mATNativeView.setVisibility(View.GONE);
                InterstitialHalfAdManager.getInstance().showAd(this);
            } else {
                InterstitialHalfAdManager.getInstance().reload();
                report(Constants.N_RELOAD);
                finish();
            }
        } else if (adType.equals(AdData.AD_TYPE_NATIVE)) {
            if (NativeAdManager.getInstance().isNativeAdReady()) {
                TUNativeView mATNativeView = findViewById(R.id.native_ad_view);
                View mSelfRenderView = findViewById(R.id.native_selfrender_view);
                mATNativeView.setVisibility(View.VISIBLE);
                NativeAdManager.getInstance().showAd(mATNativeView, mSelfRenderView);
            } else {
                NativeAdManager.getInstance().reload();
                report(Constants.N_RELOAD);
                finish();
            }
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        report("onResume");
        ALog.d(TAG, "onResume");
    }

    @Override
    protected void onPause() {
        if (!isFinished) {
            finish();
        }
        super.onPause();
        ALog.d(TAG, "onPause");
    }

    @Override
    protected void onStop() {
        ALog.d(TAG, "onStop");
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ALog.d(TAG, "onDestroy");
        NativeAdManager.getInstance().destroyAd();

    }

    @Override
    public void finish() {
        ALog.d(TAG, "finish isFinished :" + isFinished);
        if (isFinished) {
            super.finish();
            return;
        }
        report("finish");
        isFinished = true;
        super.finish();

    }

    private void report(String type) {
        Messenger messenger = InitA.getInstance().getMessenger();
        if (null == messenger) {
            return;
        }
        try {
            Map<String, String> map = new HashMap<>();
            map.put(Constants.MEDIA_PKG, getPackageName());

            ReportBean reportBean = new ReportBean();
            reportBean.setType(type);
            if (!map.isEmpty()) {
                reportBean.setData(map);
            }
            Message message = Message.obtain();
            message.what = 5002;
            Bundle bundle = new Bundle();
            bundle.putParcelable("reportBean", reportBean);
            message.setData(bundle);
            messenger.send(message);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
