package com.ads.cal.picturetranslate;

import android.app.Activity;

import com.thinkup.core.api.AdError;
import com.thinkup.core.api.TUAdInfo;
import com.thinkup.interstitial.api.TUInterstitial;
import com.thinkup.interstitial.api.TUInterstitialListener;


public class TopOnItAdManager {
    private static final String IT_AD_UNIT_ID = "b6509805ed0208";
    private static TUInterstitial itAd = null;
    private static OnItAdListener listener = null;

    public static void loadItAd() {
        if (itAd != null) {
            itAd.load();
            return;
        }

        itAd = new TUInterstitial(PictureApplication.getApplication(), IT_AD_UNIT_ID);
        itAd.setAdListener(new TUInterstitialListener() {
            @Override
            public void onInterstitialAdLoaded() {

            }

            @Override
            public void onInterstitialAdLoadFail(AdError adError) {

            }

            @Override
            public void onInterstitialAdClicked(TUAdInfo atAdInfo) {
            }

            @Override
            public void onInterstitialAdShow(TUAdInfo atAdInfo) {
                if (listener != null) {
                    listener.onShow();
                }
            }

            @Override
            public void onInterstitialAdClose(TUAdInfo atAdInfo) {
                if (listener != null) {
                    listener.onClose();
                }

                loadItAd();
            }

            @Override
            public void onInterstitialAdVideoStart(TUAdInfo atAdInfo) {

            }

            @Override
            public void onInterstitialAdVideoEnd(TUAdInfo atAdInfo) {
            }

            @Override
            public void onInterstitialAdVideoError(AdError adError) {
                if (listener != null) {
                    listener.onFail(adError.getPlatformMSG());
                }
                loadItAd();
            }
        });
        itAd.load();
    }


    public static void showItAd(Activity activity, OnItAdListener listener) {
        TopOnItAdManager.listener = listener;
        LogUtils.d("anythink showItAd");
        if (itAd == null) {
            loadItAd();
            if (listener != null) {
                listener.onFail("it ad is null");
            }

            return;
        }

        if (!itAd.isAdReady()) {
            loadItAd();
            if (listener != null) {
                listener.onFail("it ad is not ready");
            }
            return;
        }

        itAd.show(activity);
    }

    public interface OnItAdListener {
        void onShow();

        void onClose();

        void onFail(String reason);
    }
}
