package com.gem.media.ad;


import android.text.TextUtils;


import com.gem.media.InitA;

import java.util.HashMap;

public class CpAdData {
    private static boolean isInit = false;

    private static final class CpAdDataHolder {
        static final CpAdData adManager = new CpAdData();
    }

    public static CpAdData getInstance() {
        return CpAdDataHolder.adManager;
    }

    private static HashMap<String, AdData> adDataHashMap = new HashMap<>();

    public static final String CP_ADMOB = "admob";


    public void setCpData(String cp, AdData adData) {
        if (null == adDataHashMap) {
            adDataHashMap = new HashMap<>();
        }
        adDataHashMap.put(cp, adData);
    }

    public AdData getAdData(String cpId) {
        if (adDataHashMap == null) {
            adDataHashMap = new HashMap<>();
            return null;
        }
        return adDataHashMap.get(cpId);
    }

    private static final String T_ = "_";

    public static void init(String adAppId_channelId) {
        if (!TextUtils.isEmpty(adAppId_channelId)) {
            String channelId = null;
            if (adAppId_channelId.contains(T_)) {
                String[] s = adAppId_channelId.split(T_);
                if (s.length > 1) {
                    channelId = s[1];
                }
            }
            if (TextUtils.isEmpty(channelId)) {
                channelId = InitA.DEFAULT_APP_ID;
            }
            InitA.getInstance().initMediaApp(channelId);
        }
    }


}
