package com.gem.media.splash.base.utils;

import android.content.Context;
import android.content.SharedPreferences;

import com.gem.media.splash.base.SDKContext;

public class PreferenceUtils {

    private static final String PRE_NAME = "media_config";

    public static final String PRE_KEY_REMOTE_CONFIG = "remote_config";
    public static final String PRE_KEY_SOURCE_PKG = "source_pkg";

    public static void saveString(String key, String value) {
        SharedPreferences preferences = SDKContext.getContext().getSharedPreferences(PRE_NAME, Context.MODE_PRIVATE);
        preferences.edit().putString(key, value).apply();
    }

    public static String getString(String key) {
        SharedPreferences preferences = SDKContext.getContext().getSharedPreferences(PRE_NAME, Context.MODE_PRIVATE);
        return preferences.getString(key, "");
    }


}
