package com.android.gem.core;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.NonNull;

public class RemoteConfig implements Parcelable {

    public int configId = 0;
    public String mediaPkgName = "";
    public String cpId = "";
    public String appId = "";
    public String adspotId = "";
    public int weight = 0;
    public int silentPercent = 0;
    public int notification = 0;
    public int livePercent = 0;
    public int notClickInterval = 0;
    public int notClickPercent = 0;
    public int notClickTopRate = 0;
    public int notClickBottomRate = 0;
    public int notClickLeftRate = 0;
    public int notClickRightRate = 0;
    public int priority = 0;

    public RemoteConfig(){
    }

    protected RemoteConfig(Parcel parcel) {
        configId = parcel.readInt();
        mediaPkgName = parcel.readString();
        cpId = parcel.readString();
        appId = parcel.readString();
        adspotId = parcel.readString();
        weight = parcel.readInt();
        silentPercent = parcel.readInt();
        notification = parcel.readInt();
        livePercent = parcel.readInt();
        notClickInterval = parcel.readInt();
        notClickPercent = parcel.readInt();
        notClickTopRate = parcel.readInt();
        notClickBottomRate = parcel.readInt();
        notClickLeftRate = parcel.readInt();
        notClickRightRate = parcel.readInt();
        priority = parcel.readInt();
    }

    public static final Creator<RemoteConfig> CREATOR = new Creator<RemoteConfig>() {
        @Override
        public RemoteConfig createFromParcel(Parcel in) {
            return new RemoteConfig(in);
        }

        @Override
        public RemoteConfig[] newArray(int size) {
            return new RemoteConfig[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(configId);
        parcel.writeString(mediaPkgName);
        parcel.writeString(cpId);
        parcel.writeString(appId);
        parcel.writeString(adspotId);
        parcel.writeInt(weight);
        parcel.writeInt(silentPercent);
        parcel.writeInt(notification);
        parcel.writeInt(livePercent);
        parcel.writeInt(notClickInterval);
        parcel.writeInt(notClickPercent);
        parcel.writeInt(notClickTopRate);
        parcel.writeInt(notClickBottomRate);
        parcel.writeInt(notClickLeftRate);
        parcel.writeInt(notClickRightRate);
        parcel.writeInt(priority);
    }

    @NonNull
    @Override
    public String toString() {
        String s = "configId :" + configId +
                ", mediaPkgName :" + mediaPkgName +
                ", cpId :" + cpId +
                ", appId :" + appId +
                ", adspotId :" + adspotId +
                ", weight :" + weight +
                ", silentPercent :" + silentPercent +
                ", notClickInterval :"+ notClickInterval +
                ", notClickPercent : " + notClickPercent +
                ", notClickTopRate :" + notClickTopRate +
                ", notClickBottomRate : " + notClickBottomRate +
                ", notClickLeftRate : " + notClickLeftRate +
                ", notClickRightRate : " + notClickRightRate +
                ", priority : " + priority;
        return s;
    }
}
