/*
 * Decompiled with CFR 0.152.
 */
package cn.kw.lib.common;

import cn.kw.lib.common.IO;
import cn.kw.lib.common.Text;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileHelper {
    public static boolean delete(String filePath) {
        return FileHelper.delete(FileHelper.getFileByPath(filePath));
    }

    private static File getFileByPath(String filePath) {
        return Text.empty(filePath) ? null : new File(filePath);
    }

    private static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return FileHelper.deleteDir(file);
        }
        return FileHelper.deleteFile(file);
    }

    private static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !FileHelper.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static boolean copyTo(File srcFile, File targetFile) {
        boolean bl;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int lengthRead;
            in = new BufferedInputStream(new FileInputStream(srcFile));
            out = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] buffer = new byte[1024];
            while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, lengthRead);
                ((OutputStream)out).flush();
            }
            bl = true;
        }
        catch (IOException iOException) {
            IO.closeQuietly(in);
            IO.closeQuietly(out);
            catch (Throwable throwable) {
                IO.closeQuietly(in);
                IO.closeQuietly(out);
                throw throwable;
            }
        }
        IO.closeQuietly(in);
        IO.closeQuietly(out);
        return bl;
        return false;
    }

    public static boolean renameTo(File originFile, File targetFile) {
        if (originFile == null || targetFile == null || !originFile.exists()) {
            return false;
        }
        return originFile.renameTo(targetFile) || FileHelper.copyTo(originFile, targetFile);
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileHelper.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long getLength(String filePath) {
        return FileHelper.getLength(FileHelper.getFileByPath(filePath));
    }

    public static long getLength(File file) {
        if (file == null) {
            return 0L;
        }
        if (file.isDirectory()) {
            return FileHelper.getDirLength(file);
        }
        return FileHelper.getFileLength(file);
    }

    private static long getDirLength(File dir) {
        if (!FileHelper.isDir(dir)) {
            return 0L;
        }
        long len = 0L;
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    len += FileHelper.getDirLength(file);
                    continue;
                }
                len += file.length();
            }
        }
        return len;
    }

    private static long getFileLength(File file) {
        if (!FileHelper.isFile(file)) {
            return 0L;
        }
        return file.length();
    }

    public static boolean isDir(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    public static boolean isFile(File file) {
        return file != null && file.exists() && file.isFile();
    }
}

