package com.ads.cal.picturetranslate.fragment;

import android.animation.ObjectAnimator;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.ads.cal.picturetranslate.R;

public class LoadingFragment extends Fragment {

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    private ObjectAnimator rotationAnimator;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.loading_fragment, null, false);
        ImageView loading = view.findViewById(R.id.loading);
        rotationAnimator = ObjectAnimator.ofFloat(loading, "rotation", 0f, 360f);
        rotationAnimator.setDuration(2000); // 旋转一周的时间（毫秒）
        rotationAnimator.setInterpolator(new LinearInterpolator()); // 线性插值器使动画匀速旋转
        rotationAnimator.setRepeatCount(ObjectAnimator.INFINITE); // 设置为无限循环
        rotationAnimator.start(); // 启动动画
        return view;
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (rotationAnimator != null) {
            rotationAnimator.cancel();
        }
    }
}
