package com.ads.cal.picturetranslate.customeview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

public class CustomProgressBar extends View {
    private Paint backgroundPaint; // 进度条背景画笔
    private Paint progressBarPaint; // 进度条画笔
    private int progress; // 当前进度
    private int maxProgress = 100; // 最大进度
    private int progressBarHeight = 20; // 进度条高度

    public CustomProgressBar(Context context) {
        super(context);
        init();
    }

    public CustomProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    private void init() {
        backgroundPaint = new Paint();
        backgroundPaint.setColor(0xFFDFEFFF); // 进度条背景颜色

        progressBarPaint = new Paint();
        progressBarPaint.setColor(0xFF0075FF); // 进度条颜色
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        // 绘制进度条背景
        canvas.drawRect(0, 0, getWidth(), progressBarHeight, backgroundPaint);

        // 计算进度条的宽度
        int progressBarWidth = (int) ((float) progress / maxProgress * getWidth());

        // 绘制进度条
        canvas.drawRect(0, 0, progressBarWidth, progressBarHeight, progressBarPaint);
    }

    // 设置进度
    public void setProgress(int progress) {
        if (progress >= 0 && progress <= maxProgress) {
            this.progress = progress;
            invalidate(); // 重新绘制进度条
        }
    }
}
