package com.ads.cal.picturetranslate.activity;


import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.camera.core.ExperimentalGetImage;

import com.ads.cal.picturetranslate.R;
import com.ads.cal.picturetranslate.base.BaseActivity;

@ExperimentalGetImage public class PrivacyPolicyActivity extends BaseActivity {


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_privacy_policy);
         String html = "<h1>Privacy Policy</h1>\n" +
                "\n" +
                "<p>Thank you for using our Android Image Text Extraction app. We highly value your privacy, and as such, we have formulated the following privacy policy to help you understand how we collect, use, and protect your personal information. Please read the following carefully.</p>\n" +
                "\n" +
                "<h2>Collected Information</h2>\n" +
                "\n" +
                "<p>Our app uses the following third-party frameworks and permissions to provide its functionality and may collect the following information:</p>\n" +
                "\n" +
                "<h3>1. Glide</h3>\n" +
                "<p>We use Glide to load and display images. Glide may collect information about your device and image loading to enhance performance and user experience.</p>\n" +
                "\n" +
                "<h3>2. Android-Gif-Drawable</h3>\n" +
                "<p>Android-Gif-Drawable is used to support the display of GIF images. It may collect information about GIF images for proper decoding and display.</p>\n" +
                "\n" +
                "<h3>3. EventBus</h3>\n" +
                "<p>EventBus is used for event handling and communication. It may log information related to event handling but does not directly collect personally identifiable information.</p>\n" +
                "\n" +
                "<h3>4. AndroidX.Camera</h3>\n" +
                "<p>We use AndroidX.Camera to access the camera device for image text extraction. The app will require the following permissions:</p>\n" +
                "<ul>\n" +
                "    <li><code>android.permission.CAMERA</code></li>\n" +
                "    <li><code>android.hardware.camera.any</code></li>\n" +
                "    <li><code>android.hardware.camera</code> (optional, if available)</li>\n" +
                "</ul>\n" +
                "\n" +
                "<h3>5. Google ML Kit</h3>\n" +
                "<p>We use Google ML Kit for image text extraction. This framework may involve processing of image data but does not store or transmit images or extracted text data.</p>\n" +
                "\n" +
                "<h3>6. Other Permissions</h3>\n" +
                "<p>The app may also require the following permissions:</p>\n" +
                "<ul>\n" +
                "    <li><code>android.permission.RECORD_AUDIO</code></li>\n" +
                "    <li><code>android.permission.WRITE_EXTERNAL_STORAGE</code> (only for Android versions 28 and below)</li>\n" +
                "    <li><code>android.permission.READ_MEDIA_IMAGES</code></li>\n" +
                "</ul>\n" +
                "\n" +
                "<h2>Use of Information</h2>\n" +
                "\n" +
                "<p>The information we collect will be used for the following purposes:</p>\n" +
                "<ul>\n" +
                "    <li>Providing the core functionality of the app, such as image text extraction.</li>\n" +
                "    <li>Improving app performance and user experience.</li>\n" +
                "    <li>Complying with legal regulations and requirements.</li>\n" +
                "</ul>\n" +
                "\n" +
                "<h2>Protection of Information</h2>\n" +
                "\n" +
                "<p>We have implemented appropriate security measures to protect your personal information from unauthorized access, disclosure, or misuse. We retain your information only for the duration necessary to fulfill the collection purposes.</p>\n" +
                "\n" +
                "<h2>Contact Us</h2>\n" +
                "\n" +
                "<p>If you have any questions or concerns regarding our privacy policy or data processing, please feel free to contact us through the following means:</p>\n" +
                "<p>Email: quickTextCts@outlook.com</p>\n" +
                "\n" +
                "<p>This privacy policy may be updated periodically, and we recommend checking it regularly for the latest information.</p>\n" +
                "\n" +
                "<p>Last Updated: September 27, 2023</p>\n" +
                "\n" +
                "<hr>";
        TextView textView = findViewById(R.id.html);
        textView.setText(Html.fromHtml(html));
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        LinearLayout layout = findViewById(R.id.title_layout);
        layout.setOnClickListener(v -> {
            finish();
        });

    }

    public static void startPrivacyPolicyActivity(Context context) {
        Intent intent = new Intent(context, PrivacyPolicyActivity.class);
        context.startActivity(intent);
    }
}
