package com.ads.cal.notes.db;

import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class NotesSQLiteOpenHelper extends SQLiteOpenHelper {

    private static final String DATABASE_NAME = "notes_database.db";
    private static final int DATABASE_VERSION = 1;


    // 表名和列名
    public static final String TABLE_NAME = "notes";
    public static final String COLUMN_CONTENT = "content";
    public static final String COLUMN_TIME = "cTime";


    public NotesSQLiteOpenHelper(@Nullable Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_TABLE);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

    }

    // 创建表的 SQL 语句
    private static final String CREATE_TABLE = "CREATE TABLE " + TABLE_NAME + " (" +
            "_id INTEGER PRIMARY KEY AUTOINCREMENT, " +
            COLUMN_CONTENT + " TEXT," +
            COLUMN_TIME + " INTEGER);";
}
