package com.ads.cal.notes;

import android.app.Activity;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.widget.ProgressBar;

import androidx.annotation.NonNull;

import java.lang.ref.WeakReference;

public class WelcomeActivity extends BaseActivity {

    private MyHandler handler;
    @Override
    int getContentLayoutId() {
        return R.layout.activity_welcome;
    }

    private ProgressBar progressBar;

    @Override
    void initView() {
        progressBar = findViewById(R.id.progress_c);
    }

    @Override
    void intData() {
        handler = new MyHandler(this);
        handler.sendEmptyMessage(1);
    }

    public void setProgressBarProgress(int i) {
        if (i > 100) {
            if (handler != null) {
                handler.removeCallbacksAndMessages(null);
            }
            Intent intent = new Intent(this, MainActivity.class);
            startActivity(intent);
            finish();
            return;
        }
        progressBar.setProgress(i);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (null != handler) {
            handler.removeCallbacksAndMessages(null);
            handler = null;
        }
    }

    private static class MyHandler extends Handler {
        private final WeakReference<Activity> weakReference;
        private int i = 0;

        public MyHandler(Activity activity) {
            super();
            weakReference = new WeakReference<>(activity);
        }

        @Override
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            Activity activity = weakReference.get();
            sendEmptyMessageDelayed(1, 10);
            if (activity instanceof WelcomeActivity) {
                ((WelcomeActivity) activity).setProgressBarProgress(i++);
            }
        }
    }
}
