package com.ads.cal.notes.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;

import com.ads.cal.notes.LLog;
import com.ads.cal.notes.bean.DataBean;

import java.util.ArrayList;
import java.util.List;

public class DBManager {

    private final NotesSQLiteOpenHelper notesSQLiteOpenHelper;

    private SQLiteDatabase sqLiteDatabase;

    public DBManager(Context context) {
        notesSQLiteOpenHelper = new NotesSQLiteOpenHelper(context);
    }

    private static DBManager dbManager;

    public static DBManager init(Context context) {
        if (null == dbManager) {
            synchronized (DBManager.class) {
                if (dbManager == null) {
                    dbManager = new DBManager(context);
                }
                dbManager.open();
            }
        }
        return dbManager;
    }

    // 打开数据库连接
    public void open() throws SQLException {
        sqLiteDatabase = notesSQLiteOpenHelper.getWritableDatabase();
    }

    public long insertData(String content, long cTime) {
        ContentValues values = new ContentValues();
        values.put(NotesSQLiteOpenHelper.COLUMN_CONTENT, content);
        values.put(NotesSQLiteOpenHelper.COLUMN_TIME, cTime);
        return sqLiteDatabase.insert(NotesSQLiteOpenHelper.TABLE_NAME, null, values);
    }


    public boolean deleteData() {
        int rowsAffected = sqLiteDatabase.delete(
                NotesSQLiteOpenHelper.TABLE_NAME,
                null,
                null);

        return rowsAffected > 0;
    }

    public boolean deleteData(long createTime) {
        int rowsAffected = sqLiteDatabase.delete(
                NotesSQLiteOpenHelper.TABLE_NAME,
                NotesSQLiteOpenHelper.COLUMN_TIME + "=" + createTime,
                null);

        return rowsAffected > 0;
    }

    // 更新数据
    public int updateData(String content, long createTime, long updateTime) {
        ContentValues values = new ContentValues();
        values.put(NotesSQLiteOpenHelper.COLUMN_CONTENT, content);
        values.put(NotesSQLiteOpenHelper.COLUMN_TIME, updateTime);
        return sqLiteDatabase.update(NotesSQLiteOpenHelper.TABLE_NAME, values, NotesSQLiteOpenHelper.COLUMN_TIME + "=" + createTime, null);
    }

    public List<DataBean> queryData() {
        String[] columns = {NotesSQLiteOpenHelper.COLUMN_CONTENT, NotesSQLiteOpenHelper.COLUMN_TIME};
        Cursor cursor = sqLiteDatabase.query(NotesSQLiteOpenHelper.TABLE_NAME, columns, null, null, null, null, null);

        List<DataBean> dataList = new ArrayList<>();

        if (cursor != null) {
            try {
                while (cursor.moveToNext()) {
                    String content = cursor.getString(cursor.getColumnIndex(NotesSQLiteOpenHelper.COLUMN_CONTENT));
                    long time = cursor.getLong(cursor.getColumnIndex(NotesSQLiteOpenHelper.COLUMN_TIME));
                    // 创建 PictureTranslateData 对象并添加到列表中
                    DataBean data = new DataBean();
                    data.content = content;
                    data.time = time;
                    dataList.add(0, data);
                }
            } catch (Exception e) {
                LLog.e(e.getMessage());
            } finally {
                cursor.close(); // 记得关闭 Cursor
            }
        }

        return dataList;
    }

}
