package com.ads.cal.notes;

import android.app.Activity;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.widget.ProgressBar;

import androidx.annotation.NonNull;

import com.ads.cal.notes.callback.OnLoadAdEndCallBack;
import com.ads.cal.notes.callback.OnShowAdEndCallBack;
import com.ads.cal.notes.manager.GoogleMobileAdsConsentManager;
import com.ads.cal.notes.manager.InterstitialAdManager;
import com.ads.cal.notes.manager.WelcomeAdManager;
import com.google.android.ump.FormError;

import java.lang.ref.WeakReference;

public class WelcomeActivity extends BaseActivity {

    private MyHandler handler;
    @Override
    int getContentLayoutId() {
        return R.layout.activity_welcome;
    }

    private ProgressBar progressBar;

    @Override
    void initView() {
        WeakReference<Activity> weakReference = new WeakReference<>(this);
        GoogleMobileAdsConsentManager.getInstance(getApplicationContext()).gatherConsent(weakReference.get(),
                new GoogleMobileAdsConsentManager.OnConsentGatheringCompleteListener() {
            @Override
            public void consentGatheringComplete(FormError error) {

            }
        });
        progressBar = findViewById(R.id.progress_c);
    }

    @Override
    void intData() {
        handler = new MyHandler(this);
        handler.sendEmptyMessage(1);
        if (WelcomeAdManager.getInstance().isAdAvailable()) {
            showAdIfAvailable();
        } else {
            loadAd();
        }
        if (InterstitialAdManager.getInstance().hasCache()) {
            return;
        }
        InterstitialAdManager.getInstance().loadAd();
    }

    public void setProgressBarProgress(int i) {
        if (i > 100) {
            if (handler != null) {
                handler.removeCallbacksAndMessages(null);
            }
            Intent intent = new Intent(this, MainActivity.class);
            startActivity(intent);
            finish();
            return;
        }
        progressBar.setProgress(i);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (null != handler) {
            handler.removeCallbacksAndMessages(null);
            handler = null;
        }
    }

    private void showAdIfAvailable() {
        handler.removeCallbacksAndMessages(null);
        WelcomeAdManager.getInstance().setOnShowAdCallBack(new OnShowAdEndCallBack() {
            @Override
            public void onShowAdComplete() {
                Intent intent = new Intent(WelcomeActivity.this, MainActivity.class);
                startActivity(intent);
                finish();
            }

            @Override
            public void onShowAdFailed(String errorMsg) {
                Intent intent = new Intent(WelcomeActivity.this, MainActivity.class);
                startActivity(intent);
                finish();
            }
        });
        WelcomeAdManager.getInstance().showAdIfAvailable(this);
    }

    private void loadAd() {
        WelcomeAdManager.getInstance().setOnLoadAdCallBack(new OnLoadAdEndCallBack() {
            @Override
            public void onLoadAdComplete() {
                showAdIfAvailable();
            }

            @Override
            public void onLoadAdFailed(String errorMsg) {

            }
        });
        WelcomeAdManager.getInstance().loadAd();
    }

    private static class MyHandler extends Handler {
        private final WeakReference<Activity> weakReference;
        private int i = 0;

        public MyHandler(Activity activity) {
            super();
            weakReference = new WeakReference<>(activity);
        }

        @Override
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            Activity activity = weakReference.get();
            sendEmptyMessageDelayed(1, 10);
            if (activity instanceof WelcomeActivity) {
                ((WelcomeActivity) activity).setProgressBarProgress(i++);
            }
        }
    }
}
