package com.gem.media.util;

import android.graphics.Color;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;


import java.lang.reflect.Method;


public class BaseUI {

    /**
     * 全屏模式
     */
    public static void addWindowFlagByFullScreen(Window window) {
        addWindowFlagByFullScreen(window, 0);
    }

    /**
     * 全屏模式
     */
    public static void addWindowFlagByFullScreen(Window window, int uiOption) {
        window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS
                | WindowManager.LayoutParams.FLAG_TRANSLUCENT_NAVIGATION);
        int uiOptions = window.getDecorView().getSystemUiVisibility();
//        uiOptions |= 0x00000010;
        int visibility = View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                | View.SYSTEM_UI_FLAG_IMMERSIVE | uiOptions;
        if (uiOption > 0) {
            visibility = visibility | uiOption;
        }
        window.getDecorView().setSystemUiVisibility(visibility);
        window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
        window.setNavigationBarColor(Color.TRANSPARENT);
        window.setStatusBarColor(Color.TRANSPARENT);
    }

    /**
     * 修改导航栏3个按钮的颜色
     *
     * @param window
     */
    public static void addWindowFlagByUpdateUiOptions(Window window) {
        int uiOptions = window.getDecorView().getSystemUiVisibility();
        uiOptions |= 0x00000010;
        window.getDecorView().setSystemUiVisibility(uiOptions);
        window.setNavigationBarColor(Color.TRANSPARENT);
        setStatusBar(window, TitleColorUtils.getTitleColor());
    }

    private static void setStatusBar(Window window, int angle) {
        Method downPolymorphic;
        try {
            downPolymorphic = window.getClass().getMethod("setStatusBarColor", new Class[]{int.class});
            if (downPolymorphic != null)
                downPolymorphic.invoke(window, new Object[]{angle});
        } catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}
