package com.gem.media.splash.base.utils;

import android.util.Base64;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

public class StringUtil {
    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static <T> String join(T[] array, String separator) {
        return join(Arrays.asList(array), separator);
    }

    public static <T> String join(Collection<T> collection, String separator) {
        StringBuilder builder = new StringBuilder();
        if (collection.size() > 0) {
            for (T item : collection) {
                builder.append(item);
                builder.append(separator);
            }
            builder.delete(builder.length() - separator.length(), builder.length());
        }
        return builder.toString();
    }

    public static String repeat(Object value, int count) {
        return repeat(value, null, count);
    }

    public static String repeat(Object value, String separator, int count) {
        StringBuilder builder = new StringBuilder();
        if (count > 0) {
            for (int i = 0; i < count; i++) {
                builder.append(value);
                if (separator != null) {
                    builder.append(separator);
                }
            }
            if (separator != null) {
                builder.delete(builder.length() - separator.length(), builder.length());
            }
        }
        return builder.toString();
    }

    public static String base64Decode(String source) {
        return new String(Base64.decode(source, Base64.NO_WRAP));
    }
}
