package com.gem.media;

import android.os.Process;
import android.util.Log;

import com.or.ange.dot.utils.LLog;

import java.util.HashMap;
import java.util.Map;


public class CrashHandlerc implements Thread.UncaughtExceptionHandler {

    private static final String TAG = "CrashHandlerc";
    private static final String DEX_EX = "dx_crs_ex";
    private Thread.UncaughtExceptionHandler defUncaughtExceptionHandler;
    private volatile boolean isInit = false;

    private static class Holder {
        private static CrashHandlerc INSTANCE = new CrashHandlerc();
    }

    private CrashHandlerc() {
    }

    public static CrashHandlerc getInstance() {
        return Holder.INSTANCE;
    }

    public void setup() {
        if (isInit) {
            return;
        }
        isInit = true;

        defUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        String exception = Log.getStackTraceString(throwable);
        LLog.d(TAG, "exception---" + exception);
        Map<String, String> map = new HashMap<>();
        map.put("ex", exception);
        StatsStaticHelper.onEvent(DEX_EX, map);
        Process.killProcess(Process.myPid());
//            defUncaughtExceptionHandler.uncaughtException(thread, throwable);
    }

}
