package com.android.gem.core;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;
import java.util.List;

public class Node implements Parcelable {

    public String eid;
    public List<Event> events = new ArrayList<>();

    private Node(Parcel in) {
        eid = in.readString();
        in.readTypedList(events, Event.CREATOR);
    }

    public void addEvent(Event event) {
        if (event != null) {
            events.add(event);
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(eid);
        dest.writeTypedList(events);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<Node> CREATOR = new Creator<Node>() {
        @Override
        public Node createFromParcel(Parcel in) {
            return new Node(in);
        }

        @Override
        public Node[] newArray(int size) {
            return new Node[size];
        }
    };
}
