package com.ads.cal.notes.manager;

import android.app.Activity;

import androidx.annotation.NonNull;

import com.ads.cal.notes.BaseApplication;
import com.ads.cal.notes.LLog;
import com.ads.cal.notes.callback.OnLoadAdEndCallBack;
import com.ads.cal.notes.callback.OnShowAdEndCallBack;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;

public class InterstitialAdManager {
    private static final String TAG = "InterstitialAdManager";
    private static final String AD_UNIT_ID = "";



    private InterstitialAd interstitialAd;

    private boolean adIsLoading;

    private static final class AppInterstitialAdManagerHolder {
        static final InterstitialAdManager WELCOME_AD_MANAGER = new InterstitialAdManager();
    }

    public static InterstitialAdManager getInstance() {
        return InterstitialAdManager.AppInterstitialAdManagerHolder.WELCOME_AD_MANAGER;
    }

    private OnLoadAdEndCallBack onLoadAdEndCallBack;
    private OnShowAdEndCallBack onShowAdEndCallBack;


    public void setOnLoadAdCallBack(OnLoadAdEndCallBack onLoadAdEndCallBack) {
        this.onLoadAdEndCallBack = onLoadAdEndCallBack;
    }

    public void setOnShowAdCallBack(OnShowAdEndCallBack onShowAdEndCallBack) {
        this.onShowAdEndCallBack = onShowAdEndCallBack;
    }

    public void loadAd() {
        // Request a new ad if one isn't already loaded.
        if (adIsLoading || interstitialAd != null) {
            return;
        }
        adIsLoading = true;
        InterstitialAd.load(
                BaseApplication.getApplication(),
                AD_UNIT_ID,
                new AdRequest.Builder().build(),
                new InterstitialAdLoadCallback() {
                    @Override
                    public void onAdLoaded(@NonNull InterstitialAd ad) {
                        LLog.d("Ad was loaded.");
                        interstitialAd = ad;
                        adIsLoading = false;
                        if (onLoadAdEndCallBack != null) {
                            onLoadAdEndCallBack.onLoadAdComplete();
                            onLoadAdEndCallBack = null;
                        }

                        interstitialAd.setFullScreenContentCallback(
                                new FullScreenContentCallback() {
                                    @Override
                                    public void onAdDismissedFullScreenContent() {
                                        // Called when fullscreen content is dismissed.
                                        LLog.d("The ad was dismissed.");
                                        // Make sure to set your reference to null so you don't
                                        // show it a second time.
                                        interstitialAd = null;
                                        if (null != onShowAdEndCallBack) {
                                            onShowAdEndCallBack.onShowAdComplete();
                                            onShowAdEndCallBack = null;
                                        }
                                    }

                                    @Override
                                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                                        // Called when fullscreen content failed to show.
                                        LLog.d("The ad failed to show.");
                                        // Make sure to set your reference to null so you don't
                                        // show it a second time.
                                       interstitialAd = null;
                                        if (null != onShowAdEndCallBack) {
                                            onShowAdEndCallBack.onShowAdFailed(adError.getMessage());
                                            onShowAdEndCallBack = null;
                                        }
                                    }

                                    @Override
                                    public void onAdShowedFullScreenContent() {
                                        // Called when fullscreen content is shown.
                                        LLog.d("The ad was shown.");
                                    }

                                    @Override
                                    public void onAdImpression() {
                                        // Called when an impression is recorded for an ad.
                                        LLog.d("The ad recorded an impression.");
                                    }

                                    @Override
                                    public void onAdClicked() {
                                        // Called when ad is clicked.
                                        LLog.d("The ad was clicked.");
                                    }
                                });
                    }

                    @Override
                    public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                        LLog.d(loadAdError.getMessage());
                        interstitialAd = null;
                        adIsLoading = false;
                        String error =
                                String.format(
                                        java.util.Locale.US,
                                        "domain: %s, code: %d, message: %s",
                                        loadAdError.getDomain(),
                                        loadAdError.getCode(),
                                        loadAdError.getMessage());

                        if (onLoadAdEndCallBack != null) {
                            onLoadAdEndCallBack.onLoadAdFailed(error);
                            onLoadAdEndCallBack = null;
                        }
                    }
                });
    }

    private void showInterstitial(Activity activity) {
        // Show the ad if it's ready. Otherwise restart the game.
        if (interstitialAd != null) {
            interstitialAd.show(activity);
        } else {
            LLog.d("The interstitial ad is still loading.");
            if (GoogleMobileAdsConsentManager.getInstance(BaseApplication.getApplication()).canRequestAds()) {
                loadAd();
            }
        }
    }

}
