package com.ads.cal.notes;

import android.os.Bundle;
import android.os.Handler;
import android.text.Html;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.Nullable;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class TActivity extends BaseActivity {

    private  final Handler handler = new Handler();
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (init == 0) {

            moveTaskToBack(true);
            Random random = new Random();
            int d = random.nextInt(4) + 7;
            handler.removeCallbacksAndMessages(null);
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    finish();
                }
            }, d * 1000);
        }
    }

    @Override
    int getContentLayoutId() {
        return R.layout.activity_t;
    }

    @Override
    void initView() {
        TextView rt = findViewById(R.id.t);
        rt.setText(Html.fromHtml(loadHtmlFromAssets("content.html")));
        findViewById(R.id.kk).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    @Override
    void intData() {

    }

    private String loadHtmlFromAssets(String filename) {
        String htmlContent;
        try {
            InputStream inputStream = getAssets().open(filename);
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            inputStream.read(buffer);
            inputStream.close();
            htmlContent = new String(buffer);
        } catch (IOException e) {
            htmlContent = "Failed to load the HTML file.";
        }
        return htmlContent;
    }
}
