package com.ads.cal.notes;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.widget.FrameLayout;
import android.widget.Toast;

import androidx.annotation.Nullable;

import com.ads.cal.core.data.JumpInfo;
import com.ads.cal.core.utils.FragmentXUtils;
import com.ads.cal.core.views.fragments.JunkFragment;
import com.ads.cal.core.views.fragments.ProcessResultFragment;
import com.ads.cal.core.views.fragments.ProcessScanResultFragment;
import com.ads.cal.core.views.fragments.ResultFragment;
import com.gem.media.ad.AdManager;
import com.gem.media.ad.AdmobNativeManager;
import com.or.ange.dot.utils.LLog;

import java.util.Random;

public class ResultActivity extends BaseActivity{
    private static final String TAG = "CResultActivity";

    private  final Handler handler = new Handler();

    public static void start(Activity activity, JumpInfo jumpInfo, int jumpType) {
        Intent intent;
        if (activity == null) {
            intent = new Intent(BaseApplication.getApplication(), ResultActivity.class);
        } else {
            intent = new Intent(activity, ResultActivity.class);
        }
        intent.putExtra(EXAM_DATA1, jumpInfo);
        intent.putExtra(EXAM_DATA2, jumpType);
        if (activity != null) {
            activity.startActivity(intent);
        } else {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            BaseApplication.getApplication().startActivity(intent);
        }
        LLog.d(TAG, " jumpInfo "+jumpInfo.resultType+"  "+jumpInfo.junkCleanSize);
    }


    private ProcessScanResultFragment processScanResultFragment;
    private JunkFragment junkFragment;
    private ResultFragment resultFragment;
    private ProcessResultFragment processResultFragment;

    private void initClean(int jumpType) {
        Bundle bundle = new Bundle();
        JumpInfo jumpInfo = (JumpInfo) getIntent().getSerializableExtra(EXAM_DATA1);
        if (null != jumpInfo) {
            bundle.putSerializable("type", jumpInfo);
        }
        if (jumpType == JumpInfo.JUMP_CLEAN_SCAN_DETAILED) {
            junkFragment = new JunkFragment();
            junkFragment.setArguments(bundle);
            FragmentXUtils.replace(getSupportFragmentManager(), junkFragment, android.R.id.content);
            return;
        }
        if (jumpType == JumpInfo.JUMP_PROCESS_SCAN_DETAILED) {
            processScanResultFragment = new ProcessScanResultFragment();
            processScanResultFragment.setArguments(bundle);
            FragmentXUtils.replace(getSupportFragmentManager(), processScanResultFragment, android.R.id.content);
            return;
        }
//
        if (jumpType == JumpInfo.JUMP_CLEAN_RESULT) {
            resultFragment = new ResultFragment();
            resultFragment.setArguments(bundle);
            FragmentXUtils.replace(getSupportFragmentManager(), resultFragment, android.R.id.content);
            return;
        }
        if (jumpType == JumpInfo.JUMP_PROCESS_RESULT) {
            processResultFragment = new ProcessResultFragment();
            if (jumpInfo != null) {
                bundle.putInt("num", jumpInfo.stoppedPrecessNum);
            }
            processResultFragment.setArguments(bundle);
            FragmentXUtils.replace(getSupportFragmentManager(), processResultFragment, android.R.id.content);
            return;
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (init == 0) {

            Intent intent = getIntent();
            if (intent != null) {
                int jumpType = intent.getIntExtra(EXAM_DATA2, -1);
                if (jumpType != -1) {
                    initClean(jumpType);
                    return;
                }
            }
            moveTaskToBack(true);
            Random random = new Random();
            int d = random.nextInt(4) + 7;
            handler.removeCallbacksAndMessages(null);
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    finish();
                }
            }, d * 1000);
        }
    }

    @Override
    int getContentLayoutId() {
        return R.layout.activity_result;
    }

    @Override
    void initView() {

    }

    @Override
    void intData() {

    }

    private String adPosition;
    private FrameLayout frameLayout;

    @Override
    protected void onStop() {
        super.onStop();
        if (init == 0) {
            if (null != processResultFragment) {
                adPosition = processResultFragment.getMAdPosition();
                frameLayout = processResultFragment.getNativeGroupView();
                return;
            }
            if (null != resultFragment) {
                adPosition = resultFragment.getMAdPosition();
                frameLayout = resultFragment.getNativeGroupView();
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (init == 0) {
            if (null != frameLayout) {
                frameLayout.removeAllViews();
            }
            if (!TextUtils.isEmpty(adPosition)) {
                AdmobNativeManager manager = AdManager.getInstance().getAdmobNativeManager(adPosition);
                manager.release();
            }
        }
        handler.removeCallbacksAndMessages(null);
    }

    @Override
    public void onBackPressed() {
        if (init == 0) {
            if (junkFragment != null) {
                junkFragment.onBackPressed();
                return;
            }
            if (processScanResultFragment != null) {
                processScanResultFragment.onBackPressed();
                return;
            }
            super.onBackPressed();
            return;
        }
        super.onBackPressed();

    }
}
