package com.ads.cal.notes;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;

import com.ads.cal.notes.db.DBManager;
import com.ads.cal.notes.manager.WelcomeAdManager;
import com.gem.media.InitA;

public class BaseApplication extends Application implements Application.ActivityLifecycleCallbacks, LifecycleObserver {

    private static Application application;
    private static final int init = 0;

    @Override
    public void onCreate() {
        super.onCreate();
        application = this;
        if (init == 0) {
            InitA.getInstance().init(this);
            return;
        }
        this.registerActivityLifecycleCallbacks(this);
        WelcomeAdManager.initAdMobile(this);
        ProcessLifecycleOwner.get().getLifecycle().addObserver(this);

        DBManager.init(this);
    }


    public static Application getApplication() {
        return application;
    }

    public static DBManager getDataBaseManager() {
        return  DBManager.init(application);
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_START)
    protected void onMoveToForeground() {
        // Show the ad (if available) when the app moves to foreground.
        WelcomeAdManager.getInstance().showAdIfAvailable(currentActivity);
    }

    private Activity currentActivity;

    @Override
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {

    }

    @Override
    public void onActivityStarted(@NonNull Activity activity) {
        if (!WelcomeAdManager.getInstance().isShowing()) {
            currentActivity = activity;
        }
    }

    @Override
    public void onActivityResumed(@NonNull Activity activity) {

    }

    @Override
    public void onActivityPaused(@NonNull Activity activity) {

    }

    @Override
    public void onActivityStopped(@NonNull Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(@NonNull Activity activity) {

    }



}
