package com.ads.cal.marquee;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ProgressBar;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class OpenActivity extends Activity {


    private ProgressBar progressBar;

    private static final int PROGRESS_MAX = 100;
    private static final int PROGRESS_INCREMENT = 1;
    private static final long DELAY_TIME = 20; // Milliseconds

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        // 隐藏标题栏
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        // 隐藏状态栏
        getWindow().setFlags(
                WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
        // 隐藏导航栏（如果有）
        View decorView = getWindow().getDecorView();
        int uiOptions = View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN;
        decorView.setSystemUiVisibility(uiOptions);

        setContentView(R.layout.open_activity);

        progressBar = findViewById(R.id.progressBar);
        handler.sendEmptyMessageDelayed(0, DELAY_TIME);

    }

    Handler handler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(@NonNull Message message) {
            int progress = progressBar.getProgress();
            if (progress < PROGRESS_MAX) {
                progressBar.setProgress(progress + PROGRESS_INCREMENT);
                handler.sendEmptyMessageDelayed(0, DELAY_TIME);
            } else {
                redirectToOtherPage(); // 跳转到其他页面
            }
            return true;
        }
    });

    @Override
    protected void onDestroy() {
        handler.removeCallbacksAndMessages(null);
        super.onDestroy();
    }

    private void redirectToOtherPage() {
         Intent intent = new Intent(OpenActivity.this, MarqueeMActivity.class);
         startActivity(intent);
         finish();
    }
}
