package com.ads.cal.marquee;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

public class SelectColorView extends LinearLayout {

    public SelectColorView(Context context) {
        super(context);
        initView();
    }

    public SelectColorView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    public SelectColorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
    }

    public SelectColorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        initView();
    }

    private TextView title;
    private LinearLayout colorContainer;
    private FrameLayout thumb;
    private SeekBar colorSeekBar;

    private void initView() {

    }


    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        if (isInEditMode()) {
            return;
        }
        title = findViewById(R.id.text);
        colorContainer = findViewById(R.id.color_array);
        thumb = findViewById(R.id.thumb);
        colorSeekBar = findViewById(R.id.colorSeekBar);

        initData();
    }


    private void initData() {
        // 示例颜色数组
        int[] colorArray = {
                R.color.c1,
                R.color.c2,
                R.color.c3,
                R.color.c4,
                R.color.c5,
                R.color.c6,
                R.color.c7,
                R.color.c8,
                R.color.c9,
                R.color.c10,
        };

        for (int i = 0; i < colorArray.length; i ++) {
            View colorBlock = new View(getContext());
            colorBlock.setLayoutParams(new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.MATCH_PARENT, 1));
            switch (i) {
                case 0:
                    colorBlock.setBackgroundResource(R.drawable.select_color_1);
                    break;
                case 9:
                    colorBlock.setBackgroundResource(R.drawable.select_color_9);
                    break;
                default:
                    colorBlock.setBackgroundColor(ContextCompat.getColor(getContext(), colorArray[i]));
                    break;
            }
            colorContainer.addView(colorBlock);
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) thumb.getLayoutParams();
        layoutParams.width = (getScreenWidth() / 2 - dpToPx(getContext(), 40)) / 10 + 4;
        colorSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
//                float displacement = (progress / (float) seekBar.getMax()) * (getScreenWidth() - dpToPx(MarqueeMActivity.this, 40)) ;
//                Log.d("AAAA", ""+displacement);
                // 处理选中颜色的逻辑，例如更新UI
                // 你可以在这里更新选中颜色的效果

                int index = getIndex(seekBar, progress);
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) thumb.getLayoutParams();
                if (index == 0) {
                    params.leftMargin = (int) colorContainer.getChildAt(index).getX();
                } else {
                    params.leftMargin = (int) colorContainer.getChildAt(index).getX() - 2;
                }
                thumb.setLayoutParams(params);

                // 根据进度计算选中的颜色
                int selectedColor = calculateColor(index);
                if (colorCallBack != null) {
                    colorCallBack.colorValue(selectedColor);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                // 滑动开始时的处理
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });
    }

    public void setTitle(String t) {
        if (title != null) {
            title.setText(t);
        }
    }

    // 根据进度计算选中的颜色
    private int calculateColor(int index) {
        int[] colors = {R.color.c1, R.color.c2, R.color.c3, R.color.c4, R.color.c5, R.color.c6, R.color.c7, R.color.c8, R.color.c9, R.color.c10};
        if (index > 9) {
            index = 9;
        }
        return colors[index];
    }

    private int getIndex(SeekBar seekBar, int progress) {
        int index = progress * 10 / seekBar.getMax();
        if (index > 9) {
            index = 9;
        }
        return index;
    }

    private int getScreenWidth() {
        WindowManager wm = (WindowManager) getContext().getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics metrics = new DisplayMetrics();
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(metrics);
            return metrics.widthPixels;
        }
        return 0; // 默认返回0，表示未获取到屏幕宽度
    }

    private ColorCallBack colorCallBack;

    public void setColorCallBack(ColorCallBack colorCallBack) {
        this.colorCallBack = colorCallBack;
    }

    public static int dpToPx(Context context, float dp) {
        // 获取屏幕密度
        float density = context.getResources().getDisplayMetrics().density;
        // 将dp转换为px（像素）
        return Math.round(dp * density);
    }
}
