package com.ads.cal.marquee;

import static com.ads.cal.marquee.SelectColorView.dpToPx;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;

import androidx.annotation.Nullable;

public class SelectMarqueeModelView extends LinearLayout {

    public static final int SIZE = 1;
    public static final int SPEED = 2;


    public SelectMarqueeModelView(Context context) {
        super(context);
    }

    public SelectMarqueeModelView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public SelectMarqueeModelView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public SelectMarqueeModelView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        if (isInEditMode()) {
            return;
        }
        initView();
    }

    private TextView title;
    private FrameLayout thumb;
    private LinearLayout content;
    private TextView v;
    private TextView t1, t2, t3, t4, t5;

    private void initView() {
        title = findViewById(R.id.text);
        thumb = findViewById(R.id.thumb);
        content = findViewById(R.id.content);
        v = findViewById(R.id.v);

        t1 = findViewById(R.id.v1);
        t2 = findViewById(R.id.v2);
        t3 = findViewById(R.id.v3);
        t4 = findViewById(R.id.v4);
        t5 = findViewById(R.id.v5);

        SeekBar colorSeekBar = findViewById(R.id.colorSeekBar);

        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) thumb.getLayoutParams();
        layoutParams.width = (getScreenWidth() / 2 - dpToPx(getContext(), 40)) / 5 + 15;

        colorSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {

                int index = getIndex(seekBar, progress);
                if (index == -1) {
                    return;
                }
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) thumb.getLayoutParams();
                if (index == 0) {
                    params.leftMargin = (int) content.getChildAt(0).getX();
                } else {
                    params.leftMargin = (int) content.getChildAt(index * 2).getX() - 8;
                }
                thumb.setLayoutParams(params);

                if (type == SIZE) {
                    v.setText(calculateFontV(index));
                    if (textSizeCallBack != null) {
                        textSizeCallBack.textSizeValue(calculateFontSize(index), calculateD(index));
                    }
                } else if (type == SPEED) {
                    v.setText(calculateFontSpeedV(index));
                    if (scrollSpeedCallBack != null) {
                        scrollSpeedCallBack.scrollSpeedValue(calculateFontSpeed(index));
                    }
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                // 滑动开始时的处理
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });
    }

    private int type = SIZE;

    public void setData(int type) {
        this.type = type;
        if (v != null) {
            if (type == SIZE) {
                v.setText("XS");
            } else if (type == SPEED) {
                v.setText("0.25X");
                t1.setText("0.25X");
                t2.setText("0.5X");
                t3.setText("1X");
                t4.setText("1.5X");
                t5.setText("2.X");
            }
        }
        if (title != null) {
            if (type == SIZE) {
                title.setText(getResources().getString(R.string.text__size));
            } else if (type == SPEED) {
                title.setText(getResources().getString(R.string.text_f_size));
            }
        }
    }


    private int getIndex(SeekBar seekBar, int progress) {
        int index = progress * 5 / seekBar.getMax();
        if (index > 4) {
            index = 4;
        }
        return index;
    }

    private int calculateD(int index) {
        int[] d = {50, 100, 200, 300, 400};
        if (index > 4) {
            index = 4;
        }
        return d[index];
    }

    private int calculateFontSize(int index) {
        if (index > 4) {
            index = 4;
        }
        return index;
    }

    private String calculateFontV(int index) {
        String[] v = {"XS", "S", "M", "L", "XL"};
        if (index > 4) {
            index = 4;
        }
        return v[index];
    }

    private float calculateFontSpeed(int index) {
        float[] speed = {1.8f, 3.6f, 7.2f, 10.8f, 14.4f};
        if (index > 4) {
            index = 4;
        }
        return speed[index];
    }

    private String calculateFontSpeedV(int index) {
        String[] v = {"0.25X", "0.5X", "1X", "1.5X", "2X"};
        if (index > 4) {
            index = 4;
        }
        return v[index];
    }

    private int getScreenWidth() {
        WindowManager wm = (WindowManager) getContext().getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics metrics = new DisplayMetrics();
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(metrics);
            return metrics.widthPixels;
        }
        return 0; // 默认返回0，表示未获取到屏幕宽度
    }

    private int getScreenHeight() {
        WindowManager wm = (WindowManager) getContext().getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics metrics = new DisplayMetrics();
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(metrics);
            return metrics.heightPixels;
        }
        return 0; // 默认返回0，表示未获取到屏幕宽度
    }

    private TextSizeCallBack textSizeCallBack;

    public void setTextSizeCallBack(TextSizeCallBack textSizeCallBack) {
        this.textSizeCallBack = textSizeCallBack;
    }

    private ScrollSpeedCallBack scrollSpeedCallBack;

    public void setScrollSpeedCallBack(ScrollSpeedCallBack scrollSpeedCallBack) {
        this.scrollSpeedCallBack = scrollSpeedCallBack;
    }
}
