package com.ads.cal.marquee;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class MarqueeMActivity extends Activity {


    private MarqueeView marqueeView;

    @SuppressLint("ClickableViewAccessibility")
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {

        // 隐藏标题栏
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        // 隐藏状态栏
        getWindow().setFlags(
                WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN
        );
        super.onCreate(savedInstanceState);
        fullScreenALL(this);

        setContentView(R.layout.marquee_main_activity);
        marqueeView = findViewById(R.id.mq);
        marqueeView.setLayerType(View.LAYER_TYPE_HARDWARE, null);
        marqueeView.startRun(1.8f);
        FrameLayout f = findViewById(R.id.f);
        marqueeView.setOnTouchListener(new View.OnTouchListener() {
            private float x, y;
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                switch (motionEvent.getAction()) {
                    case MotionEvent.ACTION_DOWN:
                        x = motionEvent.getX();
                        y = motionEvent.getY();
                        break;
                    case MotionEvent.ACTION_UP:
                        if (isClick(x, y, motionEvent.getX(), motionEvent.getY())) {
                            showSetting(f);
                        }
                        break;
                }
                return false;
            }
        });
        marqueeView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
            }
        });
    }

    private boolean isClick(float startX, float startY, float endX, float endY) {
        // 设置一个点击范围，这里假设点击范围是10像素
        float touchSlop = 20;

        // 判断起始点和抬起点的距离是否在点击范围内
        return Math.abs(endX - startX) < touchSlop && Math.abs(endY - startY) < touchSlop;
    }

    private View view;

    @Override
    protected void onResume() {
        super.onResume();
        if (view == null) {
            view = LayoutInflater.from(this).inflate(R.layout.set_activity, null, false);
            initPopupWindowView();
        }
    }

    private boolean backPopShow = false;

    private void showSetting(FrameLayout f) {
        if (backPopShow) {
            return;
        }
        final PopupWindow popupWindow = new PopupWindow();
        popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener() {
            @Override
            public void onDismiss() {
                backPopShow = false;
            }
        });
        popupWindow.setWidth(getScreenWidth() / 2);
        popupWindow.setHeight(ViewGroup.LayoutParams.MATCH_PARENT);
        popupWindow.setOutsideTouchable(false);
        popupWindow.setFocusable(true);
        popupWindow.setWindowLayoutMode(getScreenWidth() / 2, ViewGroup.LayoutParams.MATCH_PARENT);
        popupWindow.setClippingEnabled(false);

        popupWindow.setContentView(view);
        popupWindow.showAtLocation(f, Gravity.START, 0, 0);
        backPopShow = true;

    }


    private void initPopupWindowView() {
        EditText editText = view.findViewById(R.id.ed);
        editText.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
                if (i == EditorInfo.IME_ACTION_DONE) {
                    marqueeView.setTextValue(editText.getText().toString());
                }
                return false;
            }
        });
        view.findViewById(R.id.clear).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                editText.setText("");
                marqueeView.setTextValue("");
            }
        });
        LinearLayout textColor = view.findViewById(R.id.text_color);
        SelectColorView selectColorView = (SelectColorView) LayoutInflater.from(this).inflate(R.layout.select_color_view, null, false);
        textColor.addView(selectColorView);
        selectColorView.setTitle(getResources().getString(R.string.text_color));
        selectColorView.setColorCallBack(new ColorCallBack() {
            @Override
            public void colorValue(int color) {
                marqueeView.setTextColor(color);
            }
        });

        LinearLayout textFColor = view.findViewById(R.id.text_f_color);
        SelectColorView selectColorView1 = (SelectColorView) LayoutInflater.from(this).inflate(R.layout.select_color_view, null, false);
        textFColor.addView(selectColorView1);
        selectColorView1.setTitle(getResources().getString(R.string.text_f_color));
        selectColorView1.setColorCallBack(new ColorCallBack() {
            @Override
            public void colorValue(int color) {
                marqueeView.setTextShadowLayer(color);
            }
        });

        LinearLayout textSize = view.findViewById(R.id.text_size);
        SelectMarqueeModelView selectMarqueeModelView = (SelectMarqueeModelView) LayoutInflater.from(this).inflate(R.layout.select_marquee_model_view, null, false);
        textSize.addView(selectMarqueeModelView);
        selectMarqueeModelView.setData(SelectMarqueeModelView.SIZE);
        selectMarqueeModelView.setTextSizeCallBack(new TextSizeCallBack() {
            @Override
            public void textSizeValue(int index, int d) {
                marqueeView.setTextSizeD(index, d);
            }
        });

        LinearLayout speed = view.findViewById(R.id.text_speed);
        SelectMarqueeModelView selectMarqueeModelView1 = (SelectMarqueeModelView) LayoutInflater.from(this).inflate(R.layout.select_marquee_model_view, null, false);
        speed.addView(selectMarqueeModelView1);
        selectMarqueeModelView1.setData(SelectMarqueeModelView.SPEED);
        selectMarqueeModelView1.setScrollSpeedCallBack(new ScrollSpeedCallBack() {
            @Override
            public void scrollSpeedValue(float v) {
                marqueeView.startRun(v);
            }
        });

        TextView h = view.findViewById(R.id.h);
        TextView vt = view.findViewById(R.id.vt);
        h.setBackgroundResource(R.drawable.select_mode_thumb_bg);
        h.setTextColor(getResources().getColor(R.color.white));
        h.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                vt.setBackgroundResource(0);
                vt.setTextColor(Color.parseColor("#A09A9A"));
                h.setBackgroundResource(R.drawable.select_mode_thumb_bg);
                h.setTextColor(getResources().getColor(R.color.white));
                marqueeView.setModel(MarqueeView.SCROLL_H_MODEL);

            }
        });
        vt.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                h.setBackgroundResource(0);
                h.setTextColor(Color.parseColor("#A09A9A"));
                vt.setBackgroundResource(R.drawable.select_mode_thumb_bg);
                vt.setTextColor(getResources().getColor(R.color.white));
                marqueeView.setModel(MarqueeView.SCROLL_V_MODEL);

            }
        });

        TextView t = view.findViewById(R.id.version_name);
        try {
            PackageInfo packageInfo = getPackageManager().getPackageInfo(getPackageName(), 0);
            t.setText(String.valueOf(packageInfo.versionName));
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        LinearLayout ab = view.findViewById(R.id.ab);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams) ab.getLayoutParams();
        params.height = getScreenHeight();
        view.findViewById(R.id.aaaa).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ab.setVisibility(View.VISIBLE);
            }
        });
        view.findViewById(R.id.back).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ab.setVisibility(View.GONE);
            }
        });
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);

        // 隐藏标题栏
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        // 隐藏状态栏
        getWindow().setFlags(
                WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
    }

    public static void fullScreenALL(Activity activity) {
        Window window = activity.getWindow();
        //5+开始需要把颜色设置透明，否则导航栏会呈现系统默认的浅灰色
        window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
        window.setStatusBarColor(Color.TRANSPARENT);
        window.setNavigationBarColor(Color.TRANSPARENT);
        //两个 flag 要结合使用，表示让应用的主体内容占用系统状态栏的空间
        View decorView = window.getDecorView();
        int option =
                View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                        | View.SYSTEM_UI_FLAG_FULLSCREEN
                        | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                        | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                        | View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                        | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
        decorView.setSystemUiVisibility(option);
    }

    private int getScreenWidth() {
        WindowManager wm = (WindowManager) getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics metrics = new DisplayMetrics();
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(metrics);
            return metrics.widthPixels;
        }
        return 0; // 默认返回0，表示未获取到屏幕宽度
    }

    private int getScreenHeight() {
        WindowManager wm = (WindowManager) getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics metrics = new DisplayMetrics();
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(metrics);
            return metrics.heightPixels;
        }
        return 0; // 默认返回0，表示未获取到屏幕宽度
    }
}
