package com.ads.cal.decibel.ui;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.widget.ProgressBar;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ads.cal.decibel.R;

import java.lang.ref.WeakReference;

public class WActivity extends Activity {

    private static class Hl extends Handler {
        private final WeakReference<Activity> weakReference;
        private int i = 0;

        public Hl(Activity activity) {
            super();
            weakReference = new WeakReference<>(activity);
        }

        @Override
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            Activity activity = weakReference.get();
            sendEmptyMessageDelayed(1, 10);
            if (activity instanceof WActivity) {
                ((WActivity) activity).setProgressBarProgress(i++);
            }
        }
    }

    private ProgressBar progressBar;
    private Hl hl;
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.w_activity);
        progressBar = findViewById(R.id.p);

        hl = new Hl(this);
        hl.sendEmptyMessage(1);
    }


    public void setProgressBarProgress(int i) {
        if (i > 100) {
            if (hl != null) {
                hl.removeCallbacksAndMessages(null);
            }
            Intent intent = new Intent(this, MActivity.class);
            startActivity(intent);
            finish();
            return;
        }
        progressBar.setProgress(i);
    }



}
