package com.ads.cal.decibel.ui;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;

import com.ads.cal.decibel.R;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MActivity extends Activity {

    private FrameLayout content;
    private TextView textView;
    private CRView crView;
    private TextView max, min;

    private static final int MESSAGE_WHAT_VALUE_1 = 1;
    private static final int PERMISSION_R_CODE = 2;
    private static final int A_E_FORMAT = AudioFormat.ENCODING_PCM_16BIT;
    private static final int A_C_CONFIG = AudioFormat.CHANNEL_IN_MONO;
    private static final int A_S_RATE = 44200;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.a_m);


        DisplayMetrics displayMetrics = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);

        ImageView imageView = findViewById(R.id.iv);
        RelativeLayout.LayoutParams params1 = (RelativeLayout.LayoutParams) imageView.getLayoutParams();
        params1.width = displayMetrics.widthPixels / 2;
        params1.height = displayMetrics.widthPixels / 2;


        ImageView vd = findViewById(R.id.vd);
        RelativeLayout.LayoutParams params2 = (RelativeLayout.LayoutParams) vd.getLayoutParams();
        params2.width = displayMetrics.widthPixels / 2 + pxTodp(16);
        params2.height = displayMetrics.widthPixels / 2 + pxTodp(16);


        crView = findViewById(R.id.v);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) crView.getLayoutParams();
        params.width = displayMetrics.widthPixels;
        params.height = displayMetrics.widthPixels;
        crView.startRippleAnimation();

        LinearLayout layout = findViewById(R.id.ll);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) layout.getLayoutParams();
        layoutParams.topMargin = displayMetrics.widthPixels + pxTodp(68);

        findViewById(R.id.setting).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

            }
        });
        findViewById(R.id.de).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MActivity.this, DetailActivity.class);
                startActivity(intent);
            }
        });
        findViewById(R.id.setting).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showSettingPop(v);
            }
        });
        textView = findViewById(R.id.textView);
        content = findViewById(R.id.cc);

        int color = Color.parseColor(ColorUtils.getInstance().getColor(119));
        content.setBackgroundColor(color);
        textView.setTextColor(color);
        max = findViewById(R.id.max);
        min = findViewById(R.id.min);
    }

    private AudioRecord audioRecord;
    private boolean isRecording = false;

    private void collectSound() {
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.RECORD_AUDIO) != PackageManager.PERMISSION_GRANTED) {
            ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.RECORD_AUDIO}, PERMISSION_R_CODE);
            return;
        }

        int bufferSize = AudioRecord.getMinBufferSize(A_S_RATE, A_C_CONFIG, A_E_FORMAT);
        if (bufferSize == AudioRecord.ERROR_BAD_VALUE) {
            return;
        }

        audioRecord = new AudioRecord.Builder()
                .setBufferSizeInBytes(bufferSize)
                .setAudioSource(MediaRecorder.AudioSource.MIC)
                .setAudioFormat(new AudioFormat.Builder()
                        .setChannelMask(A_C_CONFIG)
                        .setSampleRate(A_S_RATE)
                        .setEncoding(A_E_FORMAT)
                        .build())
                .build();

        audioRecord.startRecording();
        isRecording = true;

        executorService.submit(new Runnable() {
            @Override
            public void run() {
                short[] buffer = new short[bufferSize];
                int sampleCount = 0;
                double soundIntensitySum = 0;

                while (isRecording) {
                    audioRecord.read(buffer, 0, bufferSize);

                    double maxAmplitude = 0;
                    for (short s : buffer) {
                        double amplitude = Math.abs((double) s / Short.MAX_VALUE);
                        maxAmplitude = Math.max(maxAmplitude, amplitude);
                    }

                    soundIntensitySum += maxAmplitude;
                    sampleCount++;
                    // 每秒更新一次分贝值
                    if (sampleCount == A_S_RATE / (bufferSize * 3)) {
                        double threshold = 1.0e-10; // 阈值，避免除以0
                        // 计算平均声音强度的平方
                        double averageSoundIntensitySquared = Math.max(soundIntensitySum / sampleCount, threshold);
                        // 声音强度的参考值，使用20μPa
                        double referencePressure = 20.0e-6; // 20微帕斯卡
                        // 计算分贝值
                        double decibel = 20 * Math.log10(averageSoundIntensitySquared / referencePressure);
                        // 发送分贝值到主线程更新UI
                        handler.sendEmptyMessage((int) decibel);

                        // 重置计数器和声音强度总和
                        sampleCount = 0;
                        soundIntensitySum = 0;
                    }
                }

                audioRecord.stop();
                audioRecord.release();
            }
        });
    }
    

    private int pxTodp(int dpValue) {
        float density = getResources().getDisplayMetrics().density;
        return (int) (dpValue * density);
    }

    @Override
    protected void onStop() {
        super.onStop();
        isRecording = false;
    }

    @Override
    protected void onResume() {
        super.onResume();
        collectSound();
        isRecording = true;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        crView.stopRippleAnimation();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == PERMISSION_R_CODE && grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
           collectSound();
        }
    }

    private int maxValue, minValue = 120;
    @SuppressLint("HandlerLeak")
    private final Handler handler = new Handler() {


        @Override
        public void handleMessage(Message msg) {
            int value = (int) msg.what;
            if (value < 0) {
                return;
            }
            int color;
            if (value >= 120) {
                color = Color.parseColor(ColorUtils.getInstance().getColor(0));
            } else {
                color = Color.parseColor(ColorUtils.getInstance().getColor(120 - value));
            }
            try {
                getWindow().setStatusBarColor(color); // 设置颜色
            } catch (Exception e) {
                e.printStackTrace();
            }
            content.setBackgroundColor(color);
            textView.setTextColor(color);

            if (value < minValue) {
                minValue = value;
            }
            if (value > maxValue) {
                maxValue = value;
            }
            min.setText(String.valueOf(minValue));
            max.setText(String.valueOf(maxValue));
            textView.setText(String.valueOf(value));

        }
    };

    private void showSettingPop(View setting) {
        PopupWindow popupWindow = new PopupWindow();
        View view = LayoutInflater.from(this).inflate(R.layout.p, null, false);
        popupWindow.setContentView(view);
        // 测量 contentView 的宽度
        view.measure(View.MeasureSpec.UNSPECIFIED, View.MeasureSpec.UNSPECIFIED);
        // 获取 contentView 的测量宽度
        int popupWidth = view.getMeasuredWidth();
        popupWindow.setWidth(ViewGroup.LayoutParams.WRAP_CONTENT);
        popupWindow.setHeight(ViewGroup.LayoutParams.WRAP_CONTENT);
        popupWindow.setOutsideTouchable(false);
        popupWindow.setFocusable(true);
        popupWindow.setWindowLayoutMode(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        popupWindow.setClippingEnabled(false);

        // 获取按钮的位置，按钮的宽度和高度
        int[] locationOnScreen = new int[2];
        setting.getLocationOnScreen(locationOnScreen);
        float dpValue = 5; // 你要转换的dp值
        float density = getResources().getDisplayMetrics().density; // 获取屏幕的密度

        int pxValue = (int) (dpValue * density + 0.5f); // 四舍五入取整数值
        popupWindow.showAsDropDown(setting,  popupWidth - (locationOnScreen[0]) + (int)(setting.getWidth() * 2.4), pxValue);
        view.findViewById(R.id.pp).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MActivity.this, PActivity.class);
                startActivity(intent);
                popupWindow.dismiss();
            }
        });
        view.findViewById(R.id.au).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MActivity.this, BActivity.class);
                startActivity(intent);
                popupWindow.dismiss();
            }
        });
    }

    private static final ExecutorService executorService = Executors.newFixedThreadPool(5);

}
