package com.ads.cal.decibel.ui;

import android.graphics.Color;
import android.util.Log;

public class ColorUtils {

    int startColor = 0xFFDB1E11; // 起始颜色
    int endColor = 0xFF3DB801;   // 终止颜色

    private final int numSteps = 120; // 生成的中间颜色数


    private final String[] intermediateColors = new String[numSteps];


    public String getColor(int i) {
        return intermediateColors[i];
    }

    private ColorUtils() {
        i();
    }

    private static final class ColorUtilsHolder {
        static final ColorUtils colorUtils = new ColorUtils();
    }

    public static ColorUtils getInstance() {
        return ColorUtilsHolder.colorUtils;
    }


    private void i() {
        for (int i = 0; i < numSteps; i++) {
            float ratio = (float) i / (numSteps - 1);
            int interpolatedColor = interpolateColor(startColor, endColor, ratio);
            intermediateColors[i] = String.format("#%06X", 0xFFFFFF & interpolatedColor);
            Log.d("AAAAAA", intermediateColors[i]);
        }

    }

    private int interpolateColor(int color1, int color2, float ratio) {
        int r1 = Color.red(color1);
        int g1 = Color.green(color1);
        int b1 = Color.blue(color1);

        int r2 = Color.red(color2);
        int g2 = Color.green(color2);
        int b2 = Color.blue(color2);

        int interpolatedR = (int) (r1 + (r2 - r1) * ratio);
        int interpolatedG = (int) (g1 + (g2 - g1) * ratio);
        int interpolatedB = (int) (b1 + (b2 - b1) * ratio);

        return Color.rgb(interpolatedR, interpolatedG, interpolatedB);
    }
}
