package com.ads.cal.decibel.ui;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.ads.cal.decibel.R;

import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class DetailActivity extends Activity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.d_activity);
        initView();
        try {
            getWindow().setStatusBarColor(Color.parseColor("#000000")); // 设置颜色
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initView() {
        LinearLayout l = findViewById(R.id.title_layout);
        l.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });

        ListView listView = findViewById(R.id.list);
        DataAdapter dataAdapter = new DataAdapter(initData(), this);
        listView.setAdapter(dataAdapter);
    }

    private ArrayList<DataBean> initData() {
        ArrayList<DataBean> arrayList = new ArrayList<>();
        for (int i = 0; i < 6; i++) {
            DataBean dataBean = new DataBean();
            switch (i) {
                case 0:
                    dataBean.title = "0-20dB";
                    dataBean.detail = "Extremely quiet, almost unnoticeable";
                break;
                case 1:
                    dataBean.title = "20-40dB";
                    dataBean.detail = "Quiet, talk softly";
                    break;
                case 2:
                    dataBean.title = "40-60dB";
                    dataBean.detail = "Normal, ordinary indoor talking";
                    break;
                case 3:
                    dataBean.title = "60-70dB";
                    dataBean.detail = "Noisy, loud talking";
                    break;
                case 4:
                    dataBean.title = "70-90dB";
                    dataBean.detail = "Very noisy, damaging nerve cells";
                    break;
                case 5:
                    dataBean.title = "90-120dB";
                    dataBean.detail = "Extremely noisy, injuried hearing";
                    break;
            }
            arrayList.add(dataBean);

        }
        return  arrayList;
    }

    private static class DataAdapter extends BaseAdapter {

        private final String[] colors = {"#3BB800", "#A9A803", "#DD9104", "#DD5A01", "#DD4100", "#DB1D11"};
        private final String[] colorBgs = {"#103bb800", "#10A9A803", "#10DD9104", "#10DD5A01", "#10DD4100", "#10DB1D11"};

        private final ArrayList<DataBean> arrayList;
        private final WeakReference<Context> weakReference;
        public DataAdapter(ArrayList<DataBean> arrayList, Context context) {
            this.arrayList = arrayList;
            weakReference = new WeakReference<>(context);
        }

        @Override
        public int getCount() {
            return arrayList.size();
        }

        @Override
        public Object getItem(int position) {
            return arrayList.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                convertView = LayoutInflater.from(weakReference.get()).inflate(R.layout.detaile_item, null, false);
                viewHolder = new ViewHolder();
                viewHolder.position = convertView.findViewById(R.id.p);
                viewHolder.title = convertView.findViewById(R.id.t);
                viewHolder.desc = convertView.findViewById(R.id.d);
                convertView.setTag(viewHolder);
            } else {
                viewHolder = (ViewHolder) convertView.getTag();
            }

            int colorBg = Color.parseColor(colorBgs[position % colors.length]);
            GradientDrawable shape2 = new GradientDrawable();
            shape2.setShape(GradientDrawable.RECTANGLE);
            shape2.setCornerRadius(10f);
            shape2.setColor(colorBg);
            convertView.setBackground(shape2);
            // 设置圆形背景颜色
            int color = Color.parseColor(colors[position % colors.length]);
            GradientDrawable shape = new GradientDrawable();
            shape.setShape(GradientDrawable.OVAL);
            shape.setColor(color);
            viewHolder.position.setBackground(shape);


            viewHolder.position.setText(String.valueOf(position + 1));
            viewHolder.title.setText(arrayList.get(position).title);
            viewHolder.desc.setText(arrayList.get(position).detail);
            return convertView;
        }

        class ViewHolder {
            private TextView position, title, desc;
        }
    }
}
