package com.ads.cal.decibel.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;

import androidx.annotation.NonNull;


public class CRView extends View {
    private Paint paint;
    private int currentRadius, currentRadius2;
    private int ringSpacing = 120; // 同心圆之间的间隔
    private int ringSpacing2 = 120; // 同心圆之间的间隔
    private boolean isAnimating = false;

    private Handler handler = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1:
                    if (currentRadius <= screenWidth / 2 - 20) {
                        ringSpacing += 10;
                        currentRadius = ringSpacing;
                        handler.sendEmptyMessageDelayed(1, 35); // 控制扩散速度，可根据需求调整+.
                        if (currentRadius == screenWidth / 2 - 100) {
                            handler.sendEmptyMessage(2);
                        }
                    } else {
                        isAnimating = false;
                        currentRadius = 0;
                        ringSpacing = screenWidth / 4;
                    }
                    break;
                case 2:
                    if (currentRadius2 <= screenWidth / 2 - 20) {
                        ringSpacing2 += 10;
                        currentRadius2 = ringSpacing2;
                        handler.sendEmptyMessageDelayed(2, 35); // 控制扩散速度，可根据需求调整
                        if (currentRadius2 == screenWidth / 2 - 100) {
                            handler.sendEmptyMessage(1);
                        }
                    } else {
                        isAnimating = false;
                        currentRadius2 = 0;
                        ringSpacing2 = screenWidth / 4;
                    }
                    break;
            }
            invalidate();

        }
    };

    public CRView(Context context) {
        super(context);
        initView();
    }

    public CRView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    private int screenWidth;

    private void initView() {

        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager) getContext().getSystemService(Context.WINDOW_SERVICE);
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        screenWidth = displayMetrics.widthPixels;
        ringSpacing = screenWidth / 4;
        ringSpacing2 = ringSpacing;
        paint = new Paint();
        paint.setColor(Color.argb(25, 255, 255, 255)); // 初始为10%透明度的白色
        paint.setAntiAlias(true);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        int centerX = getWidth() / 2;
        int centerY = getHeight() / 2;
        canvas.drawCircle(centerX, centerY, currentRadius, paint);
        canvas.drawCircle(centerX, centerY, currentRadius2, paint);
    }

    public void startRippleAnimation() {
        if (!isAnimating) {
            isAnimating = true;
            handler.sendEmptyMessage(1);
        }
    }

    public void stopRippleAnimation() {
        isAnimating = false;
        currentRadius2 = 0;
        currentRadius = 0;
        handler.removeCallbacksAndMessages(null);
        invalidate();
    }

}