package com.ads.cal.myapplicationc

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import android.view.View
import android.view.Window
import android.view.WindowManager
import android.view.animation.Animation
import android.view.animation.AnimationUtils
import android.widget.ImageView
import com.ads.cal.myapplicationc.BaseApplication.Companion.context
import com.ads.cal.myapplicationc.BaseApplication.OnLoadAdListener
import com.ads.cal.myapplicationc.BaseApplication.OnShowAdCompleteListener
import com.ads.cal.myapplicationc.HomeActivity

class StartActivity : Activity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        this.window.setFlags(
            WindowManager.LayoutParams.FLAG_FULLSCREEN,
            WindowManager.LayoutParams.FLAG_FULLSCREEN
        )
        val view = window.decorView
        view.systemUiVisibility =
            View.SYSTEM_UI_FLAG_HIDE_NAVIGATION or View.SYSTEM_UI_FLAG_FULLSCREEN
        setContentView(R.layout.start_activity)
        val imageView = findViewById<ImageView>(R.id.anim)
        val animation = AnimationUtils.loadAnimation(
            this,
            R.anim.a
        )
        imageView.startAnimation(animation)
        animation.setAnimationListener(object : Animation.AnimationListener {
            override fun onAnimationStart(animation: Animation) {}
            override fun onAnimationEnd(animation: Animation) {
                val application = context
                if (application != null) {
                    val appOpenAdManager = application.getAppOpenAdManager()
                    if (appOpenAdManager.isShowingAd) {
                        return
                    }
                }
                finish()
                val intent = Intent(this@StartActivity, HomeActivity::class.java)
                startActivity(intent)
            }

            override fun onAnimationRepeat(animation: Animation) {}
        })
        //        gotoHome();
    }

    private fun gotoHome() {
        val application = context
        if (application != null) {
            val appOpenAdManager = application.getAppOpenAdManager()
            if (appOpenAdManager.isAdAvailable()) {
                appOpenAdManager.setOnShowAdCompleteListener(object : OnShowAdCompleteListener {
                    override fun onShowAdComplete() {
                        finish()
                        val intent = Intent(this@StartActivity, HomeActivity::class.java)
                        startActivity(intent)
                    }
                })
                appOpenAdManager.showAdIfAvailable(this)
            } else {
                appOpenAdManager.setonLoadAdCompleteListener(object : OnLoadAdListener {
                    override fun onLoadAdComplete() {
                        if (appOpenAdManager.isAdAvailable()) {
                            appOpenAdManager.setOnShowAdCompleteListener(object :
                                OnShowAdCompleteListener {
                                override fun onShowAdComplete() {
                                    finish()
                                    val intent =
                                        Intent(this@StartActivity, HomeActivity::class.java)
                                    startActivity(intent)
                                }
                            })
                        }
                        appOpenAdManager.showAdIfAvailable(this@StartActivity)
                    }
                })
                appOpenAdManager.loadAd(this)
            }
        }
    }
}